/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.pfam.transformations;

import java.io.File;
import java.io.IOException;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.pfam.transformations.PfamScanSequencesGroupTransformation;
import org.sing_group.seda.transformation.TransformationException;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;

public class PfamScanSequencesGroupDatasetTransformation
extends ComposedSequencesGroupDatasetTransformation {
    private static final String CONCURRENT_PFAM_SCAN_MESSAGE = "It seems that a PfamScan operation is already running. SEDA only allows to execute one PfamScan operation at a time in order respect EMBL-EBI policies regarding the usage of resources and avoid problems.";
    private File lockFile;

    public PfamScanSequencesGroupDatasetTransformation(PfamScanSequencesGroupTransformation pfamScanTransformation) {
        super(pfamScanTransformation);
    }

    @Override
    public SequencesGroupDataset transform(SequencesGroupDataset dataset) throws TransformationException {
        this.createLockFile();
        try {
            SequencesGroupDataset sequencesGroupDataset = super.transform(dataset);
            return sequencesGroupDataset;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this.lockFile.delete();
        }
    }

    private void createLockFile() {
        this.lockFile = new File(System.getProperty("user.home"), ".seda-pfam-scan.lock");
        if (this.lockFile.exists()) {
            throw new TransformationException(CONCURRENT_PFAM_SCAN_MESSAGE);
        }
        try {
            this.lockFile.createNewFile();
        }
        catch (IOException e) {
            throw new TransformationException("Could not create lock file", e);
        }
    }
}

