/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.transformation.provider.blast;

import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.blast.datatype.DatabaseQueryMode;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.BlastBinariesExecutor;
import org.sing_group.seda.blast.transformation.dataset.BlastTransformation;
import org.sing_group.seda.blast.transformation.dataset.BlastTransformationBuilder;
import org.sing_group.seda.blast.transformation.provider.blast.BlastTransformationConfigurationChangeType;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
public class BlastTransformationProvider
extends AbstractTransformationProvider {
    @XmlAnyElement(lax=true)
    private BlastBinariesExecutor blastBinariesExecutor;
    @XmlElement
    private boolean storeDatabases;
    @XmlElement
    private File databasesDirectory;
    @XmlElement
    private boolean storeAlias;
    @XmlElement
    private File aliasFile;
    @XmlElement
    private DatabaseQueryMode databaseQueryMode;
    @XmlElement
    private BlastType blastType;
    @XmlElement
    private File queryFile;
    @XmlElement
    private double eValue;
    @XmlElement
    private int maxTargetSeqs;
    @XmlElement
    private String additionalParameters;
    @XmlElement
    private boolean extractOnlyHitRegions;
    @XmlElement
    private int hitRegionsWindowSize;

    public BlastTransformationProvider() {
    }

    public BlastTransformationProvider(DatabaseQueryMode databaseQueryMode, BlastType blastType, Double eValue, Integer maxTargetSeqs, boolean extractOnlyHitRegions, int hitRegionsWindowSize) {
        this.databaseQueryMode = databaseQueryMode;
        this.blastType = blastType;
        this.eValue = eValue;
        this.maxTargetSeqs = maxTargetSeqs;
        this.extractOnlyHitRegions = extractOnlyHitRegions;
        this.hitRegionsWindowSize = hitRegionsWindowSize;
    }

    @Override
    public Validation validate() {
        try {
            LinkedList<String> validationErrors = new LinkedList<String>();
            if (this.databaseQueryMode == null) {
                validationErrors.add("The database query mode can't be null");
            }
            if (this.blastType == null) {
                validationErrors.add("The blast type mode can't be null");
            }
            if (this.queryFile == null) {
                validationErrors.add("The query file can't be null");
            }
            if (this.storeAlias && this.aliasFile == null) {
                validationErrors.add("The alias file can't be null");
            }
            if (this.storeDatabases && this.databasesDirectory == null) {
                validationErrors.add("The databases directory can't be null");
            }
            if (!this.isValidBlastBinariesExecutor()) {
                validationErrors.add("The BLAST binaries executor is not valid");
            }
            if (validationErrors.isEmpty()) {
                this.getBlastTransformation(DatatypeFactory.getDefaultDatatypeFactory());
                return new DefaultValidation(new String[0]);
            }
            return new DefaultValidation(validationErrors);
        }
        catch (RuntimeException ex) {
            return new DefaultValidation(ex.toString());
        }
    }

    private boolean isValidBlastBinariesExecutor() {
        if (this.blastBinariesExecutor == null) {
            return false;
        }
        try {
            this.blastBinariesExecutor.checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return this.getBlastTransformation(factory);
    }

    private BlastTransformation getBlastTransformation(DatatypeFactory factory) {
        BlastTransformationBuilder builder = new BlastTransformationBuilder(this.blastType, this.queryFile, this.databaseQueryMode).withDatatypeFactory(factory).withMaxTargetSeqs(this.maxTargetSeqs).withEvalue(this.eValue).withBlastAditionalParameters(this.additionalParameters == null ? "" : this.additionalParameters).withBlastBinariesExecutor(this.blastBinariesExecutor);
        if (this.storeDatabases) {
            builder.withDatabasesDirectory(this.databasesDirectory);
        }
        if (this.storeAlias && this.aliasFile != null) {
            builder.withAliasFile(this.aliasFile);
        }
        if (this.extractOnlyHitRegions) {
            builder.withExtractOnlyHitRegions(this.extractOnlyHitRegions).withHitRegionsWindowSize(this.hitRegionsWindowSize);
        }
        return builder.build();
    }

    public void setBlastBinariesExecutor(Optional<BlastBinariesExecutor> blastBinariesExecutor) {
        this.blastBinariesExecutor = blastBinariesExecutor.orElse(null);
        this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.BLAST_EXECUTOR_CHANGED, this.blastBinariesExecutor);
    }

    public BlastBinariesExecutor getBlastBinariesExecutor() {
        return this.blastBinariesExecutor;
    }

    public void setStoreDatabases(boolean storeDatabases) {
        if (this.storeDatabases != storeDatabases) {
            this.storeDatabases = storeDatabases;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.STORE_DATABASES_CHANGED, this.storeDatabases);
        }
    }

    public boolean isStoreDatabases() {
        return this.storeDatabases;
    }

    public void clearDatabasesDirectory() {
        this.databasesDirectory = null;
        this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.DATABASES_DIRECTORY_CHANGED, this.databasesDirectory);
    }

    public void setDatabasesDirectory(File databasesDirectory) {
        if (this.databasesDirectory == null || !this.databasesDirectory.equals(databasesDirectory)) {
            this.databasesDirectory = databasesDirectory;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.DATABASES_DIRECTORY_CHANGED, this.databasesDirectory);
        }
    }

    public File getDatabasesDirectory() {
        return this.databasesDirectory;
    }

    public void setStoreAlias(boolean storeAlias) {
        if (this.storeAlias != storeAlias) {
            this.storeAlias = storeAlias;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.STORE_ALIAS_CHANGED, this.storeAlias);
        }
    }

    public boolean isStoreAlias() {
        return this.storeAlias;
    }

    public void clearAliasFile() {
        this.aliasFile = null;
        this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.ALIAS_FILE_CHANGED, this.aliasFile);
    }

    public void setAliasFile(File aliasFile) {
        if (this.aliasFile == null || !this.aliasFile.equals(aliasFile)) {
            this.aliasFile = aliasFile;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.ALIAS_FILE_CHANGED, this.aliasFile);
        }
    }

    public File getAliasFile() {
        return this.aliasFile;
    }

    public void setDatabaseQueryMode(DatabaseQueryMode databaseQueryMode) {
        if (this.databaseQueryMode == null || !this.databaseQueryMode.equals((Object)databaseQueryMode)) {
            this.databaseQueryMode = databaseQueryMode;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.DATABASE_QUERY_MODE_CHANGED, (Object)this.databaseQueryMode);
        }
    }

    public DatabaseQueryMode getDatabaseQueryMode() {
        return this.databaseQueryMode;
    }

    public void setBlastType(BlastType blastType) {
        if (this.blastType == null || !this.blastType.equals((Object)blastType)) {
            this.blastType = blastType;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.BLAST_TYPE_CHANGED, (Object)this.blastType);
        }
    }

    public BlastType getBlastType() {
        return this.blastType;
    }

    public void clearQueryFile() {
        this.queryFile = null;
        this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.QUERY_FILE_CHANGED, this.queryFile);
    }

    public void setQueryFile(File queryFile) {
        if (this.queryFile == null || !this.queryFile.equals(queryFile)) {
            this.queryFile = queryFile;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.QUERY_FILE_CHANGED, this.queryFile);
        }
    }

    public File getQueryFile() {
        return this.queryFile;
    }

    public void setEvalue(double eValue) {
        if (this.eValue != eValue) {
            this.eValue = eValue;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.E_VALUE_CHANGED, this.eValue);
        }
    }

    public double geteValue() {
        return this.eValue;
    }

    public void setMaxTargetSeqs(int maxTargetSeqs) {
        if (this.maxTargetSeqs != maxTargetSeqs) {
            this.maxTargetSeqs = maxTargetSeqs;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.MAX_TARGET_SEQS_CHANGED, this.maxTargetSeqs);
        }
    }

    public int getMaxTargetSeqs() {
        return this.maxTargetSeqs;
    }

    public void setAdditionalParameters(String additionalParameters) {
        if (this.additionalParameters == null || !this.additionalParameters.equals(additionalParameters)) {
            this.additionalParameters = additionalParameters;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.BLAST_ADDITONAL_PARAMETERS_CHANGED, this.additionalParameters);
        }
    }

    public String getAdditionalParameters() {
        return this.additionalParameters == null ? "" : this.additionalParameters;
    }

    public void setExtractOnlyHitRegions(boolean extractOnlyHitRegions) {
        if (this.extractOnlyHitRegions != extractOnlyHitRegions) {
            this.extractOnlyHitRegions = extractOnlyHitRegions;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.EXTRACT_ONLY_HIT_REGIONS_CHANGED, this.extractOnlyHitRegions);
        }
    }

    public boolean isExtractOnlyHitRegions() {
        return this.extractOnlyHitRegions;
    }

    public void setHitRegionsWindowSize(int hitRegionsWindowSize) {
        if (this.hitRegionsWindowSize != hitRegionsWindowSize) {
            this.hitRegionsWindowSize = hitRegionsWindowSize;
            this.fireTransformationsConfigurationModelEvent(BlastTransformationConfigurationChangeType.HIT_REGIONS_WINDOW_SIZE_CHANGED, this.hitRegionsWindowSize);
        }
    }

    public int getHitRegionsWindowSize() {
        return this.hitRegionsWindowSize;
    }
}

