/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.plugin.gui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.sing_group.seda.blast.plugin.core.UniProtBlastSedaPluginInfo;
import org.sing_group.seda.blast.transformation.provider.uniprot.UniProtBlastTransformationProvider;
import org.sing_group.seda.blast.uniprot.gui.UniProtBlastTransformationConfigurationPanel;
import org.sing_group.seda.core.SedaContext;
import org.sing_group.seda.core.io.JsonObjectReader;
import org.sing_group.seda.core.io.JsonObjectWriter;
import org.sing_group.seda.plugin.core.gui.AbstractSedaGuiPlugin;
import org.sing_group.seda.plugin.spi.TransformationProvider;

public class UniProtBlastSedaGuiPlugin
extends AbstractSedaGuiPlugin {
    private UniProtBlastTransformationConfigurationPanel configurationPanel = new UniProtBlastTransformationConfigurationPanel();

    @Override
    public String getName() {
        return "UniProt BLAST";
    }

    @Override
    public String getGroupName() {
        return UniProtBlastSedaPluginInfo.GROUP;
    }

    @Override
    public String getDescription() {
        return "Perform a BLAST query through the UniProt web server (https://www.uniprot.org/blast/).";
    }

    @Override
    public Component getEditor() {
        return this.configurationPanel;
    }

    @Override
    public TransformationProvider getTransformation() {
        return this.configurationPanel.getTransformationProvider();
    }

    @Override
    public void setSedaContext(SedaContext context) {
        super.setSedaContext(context);
    }

    @Override
    public boolean canSaveTransformation() {
        return true;
    }

    @Override
    public void saveTransformation(File file) throws IOException {
        new JsonObjectWriter<UniProtBlastTransformationProvider>().write(this.configurationPanel.getTransformationProvider(), file);
    }

    @Override
    public void loadTransformation(File file) throws IOException {
        this.configurationPanel.setTransformationProvider((UniProtBlastTransformationProvider)new JsonObjectReader().read(file, UniProtBlastTransformationProvider.class));
    }
}

