/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.blast.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.blast.datatype.blast.BlastType;
import org.sing_group.seda.blast.execution.AbstractBlastBinariesExecutor;
import org.sing_group.seda.blast.execution.BlastEnvironment;

@XmlRootElement
public class DefaultBlastBinariesExecutor
extends AbstractBlastBinariesExecutor {
    @XmlTransient
    private final BlastEnvironment blast = BlastEnvironment.getInstance();
    @XmlElement
    private final File blastDirectory;
    @XmlTransient
    private Optional<Path> directoryPath;

    public DefaultBlastBinariesExecutor() {
        this(null);
    }

    public DefaultBlastBinariesExecutor(File blastDirectory) {
        this.blastDirectory = blastDirectory;
    }

    private Optional<Path> getDirectoryPath() {
        if (this.directoryPath == null) {
            this.directoryPath = this.blastDirectory == null ? Optional.empty() : Optional.of(this.blastDirectory.toPath());
        }
        return this.directoryPath;
    }

    @Override
    public void blastDbCmd(File aliasFile, File entryBatchFile, File outFile) throws IOException, InterruptedException {
        super.blastDbCmd(Arrays.asList(this.composeBlastCommand(this.blast.getBlastDbCmdCommand())), aliasFile, entryBatchFile, outFile);
    }

    @Override
    public void blastDbCmd(File aliasFile, String subjectSequenceID, String range, File outFile) throws IOException, InterruptedException {
        super.blastDbCmd(Arrays.asList(this.composeBlastCommand(this.blast.getBlastDbCmdCommand())), aliasFile, subjectSequenceID, range, outFile);
    }

    @Override
    public void blastDbCmd(File aliasFile, String subjectSequenceID, File outFile) throws IOException, InterruptedException {
        super.blastDbCmd(Arrays.asList(this.composeBlastCommand(this.blast.getBlastDbCmdCommand())), aliasFile, subjectSequenceID, outFile);
    }

    @Override
    public void makeBlastDb(File inFile, String blastSequenceType, File dbFile, boolean parseSeqIds) throws IOException, InterruptedException {
        super.makeBlastDb(Arrays.asList(this.composeBlastCommand(this.blast.getMakeBlastDbCommand())), inFile, blastSequenceType, dbFile, parseSeqIds);
    }

    @Override
    public void makeDbAlias(List<File> blastDatabases, String blastSequenceType, File outFile, String dbAliasTitle) throws IOException, InterruptedException {
        super.makeDbAlias(Arrays.asList(this.composeBlastCommand(this.blast.getBlastDbAliasToolCommand())), blastDatabases, blastSequenceType, outFile, dbAliasTitle);
    }

    @Override
    public void executeBlast(BlastType blastType, File queryFile, File database, double expectedValue, int maxTargetSeqs, File outFile, String outFormat, List<String> additionalBlastParameters) throws IOException, InterruptedException {
        super.executeBlast(Arrays.asList(this.composeBlastCommand(blastType.getCommand())), blastType, queryFile, database, expectedValue, maxTargetSeqs, outFile, outFormat, additionalBlastParameters);
    }

    @Override
    protected String composeBlastCommand(String command) {
        return this.getDirectoryPath().map(path -> path.resolve(command)).orElse(Paths.get(command, new String[0])).toString();
    }

    @Override
    protected String toFilePath(File file) {
        return file.getAbsolutePath();
    }

    public File getBlastDirectory() {
        return this.blastDirectory;
    }
}

