/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.sequencesgroup;

import java.util.function.BiPredicate;
import org.sing_group.seda.core.selection.SequenceSelector;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.transformation.sequencesgroup.FilterSequencesGroupTransformation;

public class RemoveBySizeSequencesGroupTransformation
extends FilterSequencesGroupTransformation {
    public RemoveBySizeSequencesGroupTransformation(Sequence referenceSequence, double maxSizeDifference) {
        super(RemoveBySizeSequencesGroupTransformation.buildPredicate(referenceSequence, maxSizeDifference));
    }

    public RemoveBySizeSequencesGroupTransformation(Sequence referenceSequence, double maxSizeDifference, DatatypeFactory factory) {
        super(RemoveBySizeSequencesGroupTransformation.buildPredicate(referenceSequence, maxSizeDifference), factory);
    }

    private static final BiPredicate<SequencesGroup, Sequence> buildPredicate(Sequence referenceSequence, double maxSizeDifference) {
        return (sequencesGroup, sequence) -> RemoveBySizeSequencesGroupTransformation.filter(referenceSequence, sequence, maxSizeDifference);
    }

    public RemoveBySizeSequencesGroupTransformation(SequenceSelector selector, double maxSizeDifference) {
        super(RemoveBySizeSequencesGroupTransformation.buildPredicate(selector, maxSizeDifference));
    }

    public RemoveBySizeSequencesGroupTransformation(SequenceSelector selector, double maxSizeDifference, DatatypeFactory factory) {
        super(RemoveBySizeSequencesGroupTransformation.buildPredicate(selector, maxSizeDifference), factory);
    }

    private static final BiPredicate<SequencesGroup, Sequence> buildPredicate(SequenceSelector selector, double maxSizeDifference) {
        return (sequencesGroup, sequence) -> {
            Sequence referenceSequence = selector.select((SequencesGroup)sequencesGroup);
            System.out.println("Reference: " + referenceSequence.getHeader());
            return RemoveBySizeSequencesGroupTransformation.filter(referenceSequence, sequence, maxSizeDifference);
        };
    }

    private static final boolean filter(Sequence reference, Sequence sequence, double maxSizeDifference) {
        int referenceLength = reference.getLength();
        double minLength = (double)referenceLength * (1.0 - maxSizeDifference);
        double maxLength = (double)referenceLength * (1.0 + maxSizeDifference);
        int sequenceLength = sequence.getLength();
        System.out.println("\t" + sequenceLength + "\t min = " + minLength + "\t max = " + maxLength);
        return (double)sequenceLength >= minLength && (double)sequenceLength <= maxLength;
    }
}

