/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.reformat;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.SequenceCase;
import org.sing_group.seda.io.LineBreakType;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.reformat.ReformatConfigurationChangeType;
import org.sing_group.seda.transformation.sequence.ChangePropertiesSequenceTransformation;
import org.sing_group.seda.transformation.sequencesgroup.ChangePropertiesSequencesGroupTransformation;
import org.sing_group.seda.transformation.sequencesgroup.ComposedSequencesGroupTransformation;

@XmlRootElement
public class ReformatFastaTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private boolean removeLineBreaks = false;
    @XmlElement
    private int fragmentLength = 80;
    @XmlElement
    private LineBreakType lineBreakType = LineBreakType.defaultType();
    @XmlElement
    private SequenceCase sequenceCase = SequenceCase.defaultType();

    public boolean isRemoveLineBreaks() {
        return this.removeLineBreaks;
    }

    public void setRemoveLineBreaks(boolean removeLineBreaks) {
        if (removeLineBreaks != this.removeLineBreaks) {
            this.removeLineBreaks = removeLineBreaks;
            this.fireTransformationsConfigurationModelEvent(ReformatConfigurationChangeType.REMOVE_LINE_BREAKS_CHANGED, this.removeLineBreaks);
        }
    }

    public int getFragmentLength() {
        return this.fragmentLength;
    }

    public void setFragmentLength(int fragmentLength) {
        if (this.fragmentLength != fragmentLength) {
            this.fragmentLength = fragmentLength;
            this.fireTransformationsConfigurationModelEvent(ReformatConfigurationChangeType.FRAGMENT_LENGTH_CHANGED, this.fragmentLength);
        }
    }

    public LineBreakType getLineBreakType() {
        return this.lineBreakType;
    }

    public void setLineBreakType(LineBreakType lineBreakType) {
        if (!this.lineBreakType.equals((Object)lineBreakType)) {
            this.lineBreakType = lineBreakType;
            this.fireTransformationsConfigurationModelEvent(ReformatConfigurationChangeType.LINE_BREAK_TYPE_CHANGED, (Object)this.lineBreakType);
        }
    }

    @Override
    public Validation validate() {
        if (this.removeLineBreaks || this.isValidFragmentLength()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation("The fragment length must be greater than or equal to zero.");
    }

    private boolean isValidFragmentLength() {
        return this.fragmentLength >= 0;
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        ChangePropertiesSequenceTransformation transformation = new ChangePropertiesSequenceTransformation(factory, this.getSequencePropertiesMap());
        ChangePropertiesSequencesGroupTransformation groupTransformation = new ChangePropertiesSequencesGroupTransformation(factory, this.getGroupPropertiesMap());
        return new ComposedSequencesGroupDatasetTransformation(factory, new ComposedSequencesGroupTransformation(factory, transformation), groupTransformation);
    }

    private Map<String, Object> getSequencePropertiesMap() {
        HashMap<String, Object> toret = new HashMap<String, Object>();
        if (this.getChainColumns() != 0) {
            toret.put("chain.columns", this.getChainColumns());
        }
        if (!this.getSequenceCase().equals((Object)SequenceCase.ORIGINAL)) {
            toret.put("case", (Object)this.getSequenceCase());
        }
        return toret;
    }

    private Integer getChainColumns() {
        return this.removeLineBreaks ? 0 : this.fragmentLength;
    }

    private Map<String, Object> getGroupPropertiesMap() {
        HashMap<String, Object> toret = new HashMap<String, Object>();
        toret.put("sequence.group.linebreak", this.getLineBreak());
        return toret;
    }

    private String getLineBreak() {
        return this.getLineBreakType().getLineBreak();
    }

    public SequenceCase getSequenceCase() {
        return this.sequenceCase;
    }

    public void setSequenceCase(SequenceCase sequenceCase) {
        if (!this.sequenceCase.equals((Object)sequenceCase)) {
            this.sequenceCase = sequenceCase;
            this.fireTransformationsConfigurationModelEvent(ReformatConfigurationChangeType.SEQUENCE_CASE_CHANGED, (Object)this.sequenceCase);
        }
    }
}

