/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.provider.consensus;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.bio.SequenceType;
import org.sing_group.seda.bio.consensus.ConsensusBaseStrategy;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.TransformationChangeEvent;
import org.sing_group.seda.plugin.spi.TransformationChangeListener;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.provider.consensus.GenerateConsensusSequenceTransformationChangeType;
import org.sing_group.seda.transformation.provider.reformat.ReformatFastaTransformationProvider;
import org.sing_group.seda.transformation.sequencesgroup.GenerateConsensusSequencesGroupTransformation;

@XmlRootElement
public class GenerateConsensusSequenceTransformationProvider
extends AbstractTransformationProvider {
    @XmlElement
    private boolean verbose;
    @XmlElement
    private double minimumPresence;
    @XmlElement
    private SequenceType sequenceType;
    @XmlElement
    private ConsensusBaseStrategy consensusBaseStrategy;
    private ReformatFastaTransformationProvider reformatFastaTransformationProvider;
    private TransformationChangeListener reformatFastaTransformationChangeListener = new TransformationChangeListener(){

        @Override
        public void onTransformationChange(TransformationChangeEvent event) {
            GenerateConsensusSequenceTransformationProvider.this.fireTransformationsConfigurationModelEvent(event);
        }
    };

    @Override
    public Validation validate() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (!this.reformatFastaTransformationProvider.validate().isValid()) {
            errorList.addAll(this.reformatFastaTransformationProvider.validate().getValidationErrors());
        }
        if (!this.isValidMinimumPresenceValue()) {
            errorList.add("Minimum Presence Value is not valid. It must be between 0 and 1.");
        }
        if (errorList.isEmpty()) {
            return new DefaultValidation(new String[0]);
        }
        return new DefaultValidation(errorList);
    }

    private boolean isValidMinimumPresenceValue() {
        return this.minimumPresence >= 0.0 && this.minimumPresence <= 1.0;
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return SequencesGroupDatasetTransformation.concat(new ComposedSequencesGroupDatasetTransformation(new GenerateConsensusSequencesGroupTransformation(factory, this.sequenceType, this.consensusBaseStrategy, this.minimumPresence, this.verbose)), this.reformatFastaTransformationProvider.getTransformation(factory));
    }

    public void setSequenceType(SequenceType newSequenceType) {
        if (!(newSequenceType == null || this.sequenceType != null && this.sequenceType.equals((Object)newSequenceType))) {
            this.sequenceType = newSequenceType;
            this.fireTransformationsConfigurationModelEvent(GenerateConsensusSequenceTransformationChangeType.SEQUENCE_TYPE_CHANGED, (Object)this.sequenceType);
        }
    }

    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    public void setConsensusBaseStrategy(ConsensusBaseStrategy newConsensusBaseStrategy) {
        if (!(newConsensusBaseStrategy == null || this.consensusBaseStrategy != null && this.consensusBaseStrategy.equals((Object)newConsensusBaseStrategy))) {
            this.consensusBaseStrategy = newConsensusBaseStrategy;
            this.fireTransformationsConfigurationModelEvent(GenerateConsensusSequenceTransformationChangeType.CONSENSUS_BASE_STRATEGY_CHANGED, (Object)this.consensusBaseStrategy);
        }
    }

    public ConsensusBaseStrategy getConsensusBaseStrategy() {
        return this.consensusBaseStrategy;
    }

    public void setMinimumPresence(double newMinimumPresence) {
        if (this.minimumPresence != newMinimumPresence) {
            this.minimumPresence = newMinimumPresence;
            this.fireTransformationsConfigurationModelEvent(GenerateConsensusSequenceTransformationChangeType.MINIMUM_PRESENCE_CHANGED, this.minimumPresence);
        }
    }

    public double getMinimumPresence() {
        return this.minimumPresence;
    }

    public void setVerbose(boolean newIsVerbose) {
        if (this.verbose != newIsVerbose) {
            this.verbose = newIsVerbose;
            this.fireTransformationsConfigurationModelEvent(GenerateConsensusSequenceTransformationChangeType.VERBOSE_CHANGED, this.verbose);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public ReformatFastaTransformationProvider getReformatFastaTransformationProvider() {
        return this.reformatFastaTransformationProvider;
    }

    public void setReformatFastaTransformationProvider(ReformatFastaTransformationProvider reformatFastaTransformationProvider) {
        this.reformatFastaTransformationProvider = reformatFastaTransformationProvider;
        this.reformatFastaTransformationProvider.addTransformationChangeListener(this.reformatFastaTransformationChangeListener);
    }
}

