/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.transformation.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.SequencesGroupDataset;
import org.sing_group.seda.transformation.TransformationException;

public interface SequencesGroupDatasetTransformation {
    public SequencesGroupDataset transform(SequencesGroupDataset var1) throws TransformationException;

    public static SequencesGroupDatasetTransformation concat(Collection<SequencesGroupDatasetTransformation> transformations) {
        return SequencesGroupDatasetTransformation.concat(transformations.stream());
    }

    public static SequencesGroupDatasetTransformation concat(Stream<SequencesGroupDatasetTransformation> transformations) {
        return SequencesGroupDatasetTransformation.concat((SequencesGroupDatasetTransformation[])transformations.toArray(SequencesGroupDatasetTransformation[]::new));
    }

    public static SequencesGroupDatasetTransformation concat(SequencesGroupDatasetTransformation ... transformations) {
        return dataset -> {
            SequencesGroupDataset transformedDataset = dataset;
            for (SequencesGroupDatasetTransformation transformation : transformations) {
                transformedDataset = transformation.transform(transformedDataset);
            }
            return transformedDataset;
        };
    }

    public static Collector<? super SequencesGroupDatasetTransformation, Collection<SequencesGroupDatasetTransformation>, SequencesGroupDatasetTransformation> toSequencesGroupDatasetTransformation() {
        return Collector.of(ArrayList::new, (accumulator, transformation) -> accumulator.add(transformation), (accumulator1, accumulator2) -> {
            accumulator1.addAll(accumulator2);
            return accumulator1;
        }, SequencesGroupDatasetTransformation::concat, new Collector.Characteristics[0]);
    }

    default public Map<String, Object> getDatasetPropertiesMap(SequencesGroupDataset dataset) {
        Map<String, Object> properties = Collections.emptyMap();
        Optional<SequencesGroup> firstSequencesGroup = dataset.getSequencesGroups().findFirst();
        if (firstSequencesGroup.isPresent()) {
            properties = firstSequencesGroup.get().getProperties();
        }
        return properties;
    }
}

