/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.io.IOUtils;
import org.sing_group.seda.io.NumberedLineReader;

public final class FastaReader {
    private FastaReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Stream<Sequence> readFasta(Path file, Charset charset, SequenceFromTextBuilder sequenceBuilder) {
        try (BufferedReader reader = new BufferedReader(IOUtils.createReader(file, charset));){
            String line;
            LinkedList<Sequence> sequencesList = new LinkedList<Sequence>();
            SequenceTextInfoBuilder builder = new SequenceTextInfoBuilder();
            StringBuilder chain = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                boolean isEmpty = line.isEmpty();
                boolean isSequenceStart = line.startsWith(">");
                if (isEmpty || isSequenceStart) {
                    if (builder.hasName() && chain.length() > 0) {
                        builder.setChain(chain.toString());
                        sequencesList.add(sequenceBuilder.create(builder.buildSequenceTextInfo()));
                        builder.clear();
                    } else if (builder.hasName() || chain.length() > 0) {
                        throw new IOException(String.format("Fasta syntax error. File: %s. Line: %s", file, line));
                    }
                    chain = new StringBuilder();
                }
                if (isSequenceStart) {
                    builder.setHeader(line);
                    int spaceIndex = line.indexOf(" ");
                    if (spaceIndex > 0) {
                        builder.setName(line.substring(1, spaceIndex));
                        builder.setDescription(line.substring(spaceIndex + 1));
                        continue;
                    }
                    builder.setName(line.substring(1));
                    continue;
                }
                if (isEmpty) continue;
                if (!builder.hasName()) {
                    throw new IOException(String.format("Fasta syntax error. File: %s. Line: %s", file, line));
                }
                String nextChainLine = line.trim();
                chain.append(nextChainLine);
                builder.updateChainColumns(nextChainLine.length());
            }
            if (builder.hasName() && chain.length() > 0) {
                builder.setChain(chain.toString());
                sequencesList.add(sequenceBuilder.create(builder.buildSequenceTextInfo()));
                builder.clear();
            } else {
                if (builder.hasName()) throw new IOException("Incomplete file");
                if (chain.length() > 0) {
                    throw new IOException("Incomplete file");
                }
            }
            Stream<Sequence> stream = sequencesList.stream();
            return stream;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading file: " + file.toString(), ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Stream<Sequence> readFasta(Path file, Charset charset, SequenceFromLocationsBuilder sequenceBuilder) {
        try (NumberedLineReader reader = new NumberedLineReader(IOUtils.createInputStream(file), charset);){
            NumberedLineReader.Line nline;
            LinkedList<Sequence> sequencesList = new LinkedList<Sequence>();
            SequenceLocationsInfoBuilder builder = new SequenceLocationsInfoBuilder(file, charset, reader.getCharset());
            while ((nline = reader.readLine()) != null) {
                String line = nline.getLine().trim();
                boolean isEmpty = line.isEmpty();
                boolean isSequenceStart = line.startsWith(">");
                if (isEmpty || isSequenceStart) {
                    if (builder.hasSequenceTextInfo()) {
                        sequencesList.add(sequenceBuilder.create(builder.buildSequenceTextInfo()));
                        builder.clear();
                    } else if (builder.hasName() || builder.hasChain()) {
                        throw new IOException(String.format("Fasta syntax error. File: %s. Line: %s", file, line));
                    }
                }
                if (isSequenceStart) {
                    boolean hasDescription;
                    int nameLength;
                    int spaceIndex = line.indexOf(" ");
                    if (spaceIndex > 0) {
                        nameLength = nline.countTextBytesBetween(1, spaceIndex - 1);
                        hasDescription = spaceIndex < nline.countTextChars() - 1;
                    } else {
                        nameLength = nline.countTextBytesFrom(1);
                        hasDescription = false;
                    }
                    builder.setHeaderLocation(nline.getStart());
                    builder.setHeaderLength(nline.countTextBytes());
                    builder.setNameLocation(nline.getCharPosition(1));
                    builder.setNameLength(nameLength);
                    if (!hasDescription) continue;
                    int descriptionStart = spaceIndex + 1;
                    builder.setDescriptionLocation(nline.getCharPosition(descriptionStart));
                    builder.setDescriptionLength(nline.countTextBytesFrom(descriptionStart));
                    continue;
                }
                if (isEmpty) continue;
                if (!builder.hasName()) {
                    throw new IOException(String.format("Fasta syntax error. File: %s. Line: %s", file, line));
                }
                String nextChainLine = line.trim();
                if (!builder.hasChain()) {
                    builder.setChainLocation(nline.getStart());
                }
                builder.updateChainColumns(nextChainLine.length());
                builder.setChainLength((int)(nline.getTextEnd() - builder.getChainLocation() + 1L));
            }
            if (builder.hasSequenceTextInfo()) {
                sequencesList.add(sequenceBuilder.create(builder.buildSequenceTextInfo()));
                builder.clear();
            } else {
                if (builder.hasName()) throw new IOException("Incomplete file");
                if (builder.hasChain()) {
                    throw new IOException("Incomplete file");
                }
            }
            Stream<Sequence> stream = sequencesList.stream();
            return stream;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading file: " + file.toString(), ioe);
        }
    }

    private static class SequenceLocationsInfoBuilder {
        private final Path file;
        private final Charset charset;
        private final Charset charsetSubtype;
        private long nameLocation;
        private int nameLength;
        private long descriptionLocation;
        private int descriptionLength;
        private long headerLocation;
        private int headerLength;
        private long chainLocation;
        private int chainLength;
        private int columnWidth;
        private Map<String, Object> properties;

        public SequenceLocationsInfoBuilder(Path file, Charset charset, Charset charsetSubtype) {
            this.file = file;
            this.charset = charset;
            this.charsetSubtype = charsetSubtype;
            this.clear();
        }

        public boolean hasSequenceTextInfo() {
            return this.nameLength > 0 && this.chainLength > 0;
        }

        public boolean hasName() {
            return this.nameLength > 0;
        }

        public boolean hasChain() {
            return this.chainLength > 0;
        }

        public void setNameLocation(long nameLocation) {
            if (nameLocation < 0L) {
                throw new IllegalArgumentException("Name location should be greater than 0");
            }
            this.nameLocation = nameLocation;
        }

        public void setNameLength(int nameLength) {
            if (this.nameLocation < 0L) {
                throw new IllegalStateException("Name location must be set before name length");
            }
            if (nameLength < 0) {
                throw new IllegalArgumentException("Name length should be greater than 0");
            }
            this.nameLength = nameLength;
        }

        public void setDescriptionLocation(long descriptionLocation) {
            if (descriptionLocation < 0L) {
                throw new IllegalArgumentException("Description location should be greater than 0");
            }
            this.descriptionLocation = descriptionLocation;
        }

        public void setDescriptionLength(int descriptionLength) {
            if (this.descriptionLocation < 0L) {
                throw new IllegalStateException("Description location must be set before description length");
            }
            if (descriptionLength < 0) {
                throw new IllegalArgumentException("Description length should be greater than 0");
            }
            this.descriptionLength = descriptionLength;
        }

        public void setHeaderLocation(long headerLocation) {
            if (headerLocation < 0L) {
                throw new IllegalArgumentException("Header location should be greater than 0");
            }
            this.headerLocation = headerLocation;
        }

        public void setHeaderLength(int headerLength) {
            if (this.headerLocation < 0L) {
                throw new IllegalStateException("Header location must be set before header length");
            }
            if (headerLength < 0) {
                throw new IllegalArgumentException("Header length should be greater than 0");
            }
            this.headerLength = headerLength;
        }

        public long getChainLocation() {
            return this.chainLocation;
        }

        public void setChainLocation(long chainLocation) {
            if (chainLocation < 0L) {
                throw new IllegalArgumentException("Chain location should be greater than 0");
            }
            this.chainLocation = chainLocation;
        }

        public void setChainLength(int chainLength) {
            if (this.chainLocation < 0L) {
                throw new IllegalStateException("Chain location must be set before chain length");
            }
            if (chainLength < 0) {
                throw new IllegalArgumentException("Chain length should be greater than 0");
            }
            this.chainLength = chainLength;
        }

        public void updateChainColumns(int columns) {
            if (columns < 0) {
                throw new IllegalArgumentException("Chain columns should be greater than 0");
            }
            this.columnWidth = Math.max(this.columnWidth, columns);
            this.properties.put("chain.columns", this.columnWidth);
        }

        public SequenceLocationsInfo buildSequenceTextInfo() {
            return new SequenceLocationsInfo(this.file, this.charset, this.charsetSubtype, this.nameLocation, this.nameLength, this.descriptionLocation, this.descriptionLength, this.headerLocation, this.headerLength, this.chainLocation, this.chainLength, this.columnWidth, this.properties);
        }

        public void clear() {
            this.nameLocation = -1L;
            this.nameLength = -1;
            this.descriptionLocation = -1L;
            this.descriptionLength = -1;
            this.headerLocation = -1L;
            this.headerLength = -1;
            this.chainLocation = -1L;
            this.chainLength = -1;
            this.columnWidth = 0;
            this.properties = new HashMap<String, Object>();
        }
    }

    private static class SequenceTextInfoBuilder {
        private String name;
        private String description;
        private String header;
        private String chain;
        private int columnWidth;
        private Map<String, Object> properties;

        public SequenceTextInfoBuilder() {
            this.clear();
        }

        public boolean hasName() {
            return this.name != null;
        }

        public void setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name can't be null");
            }
            this.name = name;
        }

        public void setDescription(String description) {
            if (description == null) {
                throw new IllegalArgumentException("Description can't be null");
            }
            this.description = description;
        }

        public void setHeader(String header) {
            if (header == null) {
                throw new IllegalArgumentException("Header can't be null");
            }
            this.header = header;
        }

        public void setChain(String chain) {
            if (chain == null) {
                throw new IllegalArgumentException("Chain can't be null");
            }
            this.chain = chain;
        }

        public void updateChainColumns(int columns) {
            if (columns < 0) {
                throw new IllegalArgumentException("Chain columns should be greater than 0");
            }
            this.columnWidth = Math.max(this.columnWidth, columns);
            this.properties.put("chain.columns", this.columnWidth);
        }

        public SequenceTextInfo buildSequenceTextInfo() {
            return new SequenceTextInfo(this.name, this.description, this.header, this.chain, this.columnWidth, this.properties);
        }

        public void clear() {
            this.name = null;
            this.description = null;
            this.header = null;
            this.chain = null;
            this.columnWidth = 0;
            this.properties = new HashMap<String, Object>();
        }
    }

    public static class SequenceTextInfo {
        private final String name;
        private final String description;
        private final String header;
        private final String chain;
        private final int columnWidth;
        private final Map<String, Object> properties;

        SequenceTextInfo(String name, String description, String header, String chain, int columnWidth, Map<String, Object> properties) {
            this.name = name;
            this.description = description;
            this.header = header;
            this.chain = chain;
            this.columnWidth = columnWidth;
            this.properties = properties;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getHeader() {
            return this.header;
        }

        public String getChain() {
            return this.chain;
        }

        public int getColumnWidth() {
            return this.columnWidth;
        }

        public Map<String, Object> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public int hashCode() {
            return Objects.hash(this.chain, this.columnWidth, this.description, this.header, this.name, this.properties);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SequenceTextInfo other = (SequenceTextInfo)obj;
            return Objects.equals(this.chain, other.chain) && this.columnWidth == other.columnWidth && Objects.equals(this.description, other.description) && Objects.equals(this.header, other.header) && Objects.equals(this.name, other.name) && Objects.equals(this.properties, other.properties);
        }
    }

    public static class SequenceLocationsInfo {
        private final Path file;
        private final Charset charset;
        private final Charset charsetSubtype;
        private final long nameLocation;
        private final int nameLength;
        private final long descriptionLocation;
        private final int descriptionLength;
        private final long headerLocation;
        private final int headerLength;
        private final long chainLocation;
        private final int chainLength;
        private final int columnWidth;
        private final Map<String, Object> properties;

        SequenceLocationsInfo(Path file, Charset charset, Charset charsetSubtype, long nameLocation, int nameLength, long descriptionLocation, int descriptionLength, long headerLocation, int headerLength, long chainLocation, int chainLength, int columnWidth, Map<String, Object> properties) {
            this.file = file;
            this.charset = charset;
            this.charsetSubtype = charsetSubtype;
            this.nameLocation = nameLocation;
            this.nameLength = nameLength;
            this.descriptionLocation = descriptionLocation;
            this.descriptionLength = descriptionLength;
            this.headerLocation = headerLocation;
            this.headerLength = headerLength;
            this.chainLocation = chainLocation;
            this.chainLength = chainLength;
            this.columnWidth = columnWidth;
            this.properties = properties;
        }

        public Path getFile() {
            return this.file;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Charset getCharsetSubtype() {
            return this.charsetSubtype;
        }

        public long getNameLocation() {
            return this.nameLocation;
        }

        public int getNameLength() {
            return this.nameLength;
        }

        public long getDescriptionLocation() {
            return this.descriptionLocation;
        }

        public int getDescriptionLength() {
            return this.descriptionLength;
        }

        public long getHeaderLocation() {
            return this.headerLocation;
        }

        public int getHeaderLength() {
            return this.headerLength;
        }

        public long getChainLocation() {
            return this.chainLocation;
        }

        public int getChainLength() {
            return this.chainLength;
        }

        public int getColumnWidth() {
            return this.columnWidth;
        }

        public Map<String, Object> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public int hashCode() {
            return Objects.hash(this.chainLength, this.chainLocation, this.charset, this.charsetSubtype, this.columnWidth, this.descriptionLength, this.descriptionLocation, this.file, this.headerLength, this.headerLocation, this.nameLength, this.nameLocation, this.properties);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SequenceLocationsInfo other = (SequenceLocationsInfo)obj;
            return this.chainLength == other.chainLength && this.chainLocation == other.chainLocation && Objects.equals(this.charset, other.charset) && Objects.equals(this.charsetSubtype, other.charsetSubtype) && this.columnWidth == other.columnWidth && this.descriptionLength == other.descriptionLength && this.descriptionLocation == other.descriptionLocation && Objects.equals(this.file, other.file) && this.headerLength == other.headerLength && this.headerLocation == other.headerLocation && this.nameLength == other.nameLength && this.nameLocation == other.nameLocation && Objects.equals(this.properties, other.properties);
        }

        public String toString() {
            return "SequenceLocationsInfo [file=" + this.file + ", charset=" + this.charset + ", charsetSubtype=" + this.charsetSubtype + ", nameLocation=" + this.nameLocation + ", nameLength=" + this.nameLength + ", descriptionLocation=" + this.descriptionLocation + ", descriptionLength=" + this.descriptionLength + ", headerLocation=" + this.headerLocation + ", headerLength=" + this.headerLength + ", chainLocation=" + this.chainLocation + ", chainLength=" + this.chainLength + ", columnWidth=" + this.columnWidth + ", properties=" + this.properties + "]";
        }
    }

    @FunctionalInterface
    public static interface SequenceFromLocationsBuilder {
        public Sequence create(SequenceLocationsInfo var1);
    }

    @FunctionalInterface
    public static interface SequenceFromTextBuilder {
        public Sequence create(SequenceTextInfo var1);
    }
}

