/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.split.regex;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.core.filtering.RegexHeaderMatcher;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.configuration_panel.filtering.header.RegexHeaderMatcherConfigurationPanel;
import org.sing_group.seda.plugin.core.info.plugin.RegexSplitSedaPluginInfo;
import org.sing_group.seda.transformation.provider.split.regex.RegexSplitConfigurationTransformationProvider;

public class RegexSplitConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DESCRIPTION_HEADER_MATCHER = "This option allows to specify how sequences must be grouped to form the new files.";
    private static final String DESCRIPTION_GROUP_NAMES_FILES_DIRECTORY = RegexSplitSedaPluginInfo.PARAM_GROUP_NAMES_FILES_DIRECTORY_HELP_GUI;
    private RegexHeaderMatcherConfigurationPanel headerMatcherPanel;
    private RegexSplitConfigurationTransformationProvider transformationProvider = new RegexSplitConfigurationTransformationProvider();
    private JFileChooserPanel saveGroupNamesDirectory;

    public RegexSplitConfigurationPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.getParametersPanel(), "Center");
        return new CenteredJPanel((Component)mainPanel);
    }

    private JPanel getParametersPanel() {
        return new InputParametersPanel(this.getInputParameters());
    }

    private InputParameter[] getInputParameters() {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getHeaderMatcherParameter());
        parameters.add(this.getSaveGroupNamesDirectoryParameter());
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getHeaderMatcherParameter() {
        this.headerMatcherPanel = new RegexHeaderMatcherConfigurationPanel();
        this.headerMatcherPanel.setBorder(BorderFactory.createTitledBorder("Header matcher configuration"));
        this.headerMatcherPanel.addPropertyChangeListener(this::headerMatcherChanged);
        return new InputParameter("", (JComponent)this.headerMatcherPanel, DESCRIPTION_HEADER_MATCHER);
    }

    private void headerMatcherChanged(PropertyChangeEvent event) {
        if (RegexHeaderMatcherConfigurationPanel.PROPERTIES.contains(event.getPropertyName())) {
            Optional<RegexHeaderMatcher> headerMatcher = this.headerMatcherPanel.getRegexHeaderMatcher();
            if (headerMatcher.isPresent()) {
                this.transformationProvider.setHeaderMatcher(headerMatcher.get());
            } else {
                this.transformationProvider.removeHeaderMatcher();
            }
        }
    }

    private InputParameter getSaveGroupNamesDirectoryParameter() {
        this.saveGroupNamesDirectory = JFileChooserPanelBuilder.createSaveJFileChooserPanel().withFileChooserSelectionMode(SelectionMode.DIRECTORIES).withFileChooser(CommonFileChooser.getInstance().getFilechooser()).withLabel("").build();
        this.saveGroupNamesDirectory.addFileChooserListener(this::saveGroupNamesDirectoryChanged);
        return new InputParameter("Group names files directory: ", (JComponent)this.saveGroupNamesDirectory, DESCRIPTION_GROUP_NAMES_FILES_DIRECTORY);
    }

    private void saveGroupNamesDirectoryChanged(ChangeEvent event) {
        File selectedFile = this.saveGroupNamesDirectory.getSelectedFile();
        if (selectedFile != null) {
            this.transformationProvider.setSaveGroupNamesDirectory(selectedFile);
        } else {
            this.transformationProvider.removeSaveGroupNamesDirectory();
        }
    }

    public RegexSplitConfigurationTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(RegexSplitConfigurationTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        if (this.transformationProvider.getRegexHeaderMatcher() != null) {
            this.headerMatcherPanel.setRegexHeaderMatcher(this.transformationProvider.getRegexHeaderMatcher());
        }
        if (this.transformationProvider.getSaveGroupNamesDirectory() != null) {
            this.saveGroupNamesDirectory.setSelectedFile(this.transformationProvider.getSaveGroupNamesDirectory());
        } else {
            this.saveGroupNamesDirectory.clearSelectedFile();
        }
    }
}

