/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel.pattern;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.sing_group.gc4s.dialog.JOptionPaneMessage;
import org.sing_group.gc4s.ui.menu.HamburgerMenu;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.datatype.SequencesGroup;
import org.sing_group.seda.datatype.pattern.EvaluableSequencePattern;
import org.sing_group.seda.datatype.pattern.SequencePattern;
import org.sing_group.seda.datatype.pattern.SequencePatternGroup;
import org.sing_group.seda.gui.CommonFileChooser;
import org.sing_group.seda.gui.configuration_panel.pattern.PatternEditionEvent;
import org.sing_group.seda.gui.configuration_panel.pattern.SequencePatternEditorAdapter;
import org.sing_group.seda.gui.configuration_panel.pattern.SequencePatternEditorListener;
import org.sing_group.seda.gui.configuration_panel.pattern.SequencePatternPanel;

public class SequencePatternGroupPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final JOptionPaneMessage EDIT_OTHER_PATTERNS_MESSAGE = new JOptionPaneMessage("Dou you want to set the same value in the rest of patterns of this group?");
    private static boolean lastEditOtherPatternsResponse = false;
    private SequencePatternGroup initialGroup;
    private JComboBox<EvaluableSequencePattern.GroupMode> patternsModeCombo;
    private JPanel sequencePatternsPanel;
    private List<SequencePatternPanelComponent> sequencePatternComponents = new ArrayList<SequencePatternPanelComponent>();
    private boolean ignorePatternEditionEvents = false;

    public SequencePatternGroupPanel() {
        this.init();
    }

    public SequencePatternGroupPanel(SequencePatternGroup group) {
        this.initialGroup = group;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getNorthComponent(), "North");
        this.add(this.getCenterComponent(), "Center");
    }

    protected JPanel getNorthComponent() {
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.add(new JLabel("Required patterns: "));
        northPanel.add(this.getPatternsModeCombobox());
        northPanel.add(Box.createHorizontalGlue());
        northPanel.add(Box.createHorizontalStrut(5));
        northPanel.add(this.getAddPatternButton());
        northPanel.add(Box.createHorizontalStrut(5));
        northPanel.add(this.getImportPatternsMenu());
        northPanel.add(Box.createHorizontalStrut(5));
        northPanel.add(this.getRemoveAllPatternsButton());
        return northPanel;
    }

    private JButton getAddPatternButton() {
        JButton addPattern = new JButton("Add pattern");
        addPattern.addActionListener(event -> this.addSequencePatternPanelComponent());
        return addPattern;
    }

    private JComponent getImportPatternsMenu() {
        HamburgerMenu menu = new HamburgerMenu(HamburgerMenu.Size.SIZE16);
        menu.setIcon(null);
        menu.setText("Import patterns");
        menu.setMaximumSize(new Dimension(130, 27));
        menu.add((Action)new AbstractAction("From plain-text file"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SequencePatternGroupPanel.this.importPatternsList();
            }
        });
        menu.add((Action)new AbstractAction("From FASTA file (sequence IDs)"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SequencePatternGroupPanel.this.importSequenceIdentifiersPatterns();
            }
        });
        menu.add((Action)new AbstractAction("From FASTA file (headers)"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SequencePatternGroupPanel.this.importSequenceHeadersPatterns();
            }
        });
        menu.add((Action)new AbstractAction("From FASTA file (sequences)"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SequencePatternGroupPanel.this.importSequencePatterns();
            }
        });
        return menu;
    }

    private JButton getRemoveAllPatternsButton() {
        JButton removeAllPatternsButton = new JButton("Remove all");
        removeAllPatternsButton.addActionListener(event -> this.removeAllPatternsList());
        return removeAllPatternsButton;
    }

    private Component getPatternsModeCombobox() {
        this.patternsModeCombo = new JComboBox<EvaluableSequencePattern.GroupMode>(EvaluableSequencePattern.GroupMode.values());
        if (this.initialGroup != null) {
            this.patternsModeCombo.setSelectedItem((Object)this.initialGroup.getMode());
        }
        this.patternsModeCombo.addItemListener(this::modeComboChanged);
        return this.patternsModeCombo;
    }

    private void modeComboChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            this.notifyPatternEdited(new PatternEditionEvent(this, PatternEditionEvent.PatternEditionType.MODE));
        }
    }

    private Component getCenterComponent() {
        JPanel centerPanel = new JPanel();
        this.sequencePatternsPanel = new JPanel();
        this.sequencePatternsPanel.setLayout(new BoxLayout(this.sequencePatternsPanel, 1));
        centerPanel.add(this.sequencePatternsPanel);
        if (this.initialGroup == null) {
            this.addSequencePatternPanelComponent();
        } else {
            this.addSequencePatternPanels();
        }
        return new JScrollPane(centerPanel);
    }

    private void addSequencePatternPanelComponent() {
        this.addSequencePatternPanelComponent("");
    }

    private void addSequencePatternPanelComponent(String pattern) {
        this.addSequencePatternPanelComponent(new SequencePatternPanelComponent(pattern));
    }

    private void addSequencePatternPanelComponent(SequencePatternPanelComponent component) {
        this.sequencePatternComponents.add(component);
        this.sequencePatternsPanel.add(component);
        this.notifyPatternAdded();
        this.updateUI();
    }

    private void addSequencePatternPanels() {
        this.ignorePatternEditionEvents = true;
        for (EvaluableSequencePattern esp : this.initialGroup.getPatterns()) {
            if (!(esp instanceof SequencePattern)) continue;
            SequencePattern pattern = (SequencePattern)esp;
            this.addSequencePatternPanelComponent(new SequencePatternPanelComponent(pattern));
        }
        this.ignorePatternEditionEvents = false;
    }

    private void removeSequencePatternComponent(SequencePatternPanelComponent component) {
        this.sequencePatternComponents.remove(component);
        this.sequencePatternsPanel.remove(component);
        this.notifyPatternRemoved();
        this.updateUI();
    }

    private void removeAllPatternsList() {
        this.sequencePatternComponents.clear();
        this.sequencePatternsPanel.removeAll();
        this.notifyPatternRemoved();
        this.updateUI();
    }

    private Optional<File> getPatternsFile() {
        JFileChooser fileChooser = CommonFileChooser.getInstance().getFilechooser();
        fileChooser.setFileSelectionMode(0);
        int option = fileChooser.showSaveDialog(this);
        fileChooser.setFileSelectionMode(2);
        if (option == 0) {
            return Optional.of(fileChooser.getSelectedFile());
        }
        return Optional.empty();
    }

    private void importPatternsList() {
        Optional<File> patternsFile = this.getPatternsFile();
        if (patternsFile.isPresent()) {
            this.importPatternsList(patternsFile.get());
        }
    }

    private void importPatternsList(File file) {
        try {
            List<String> lines = Files.readAllLines(file.toPath());
            for (String line : lines) {
                this.addSequencePatternPanelComponent(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void importSequencePatterns() {
        Optional<File> patternsFile = this.getPatternsFile();
        if (patternsFile.isPresent()) {
            this.importSequencePatterns(patternsFile.get(), Sequence::getChain);
        }
    }

    private void importSequenceHeadersPatterns() {
        Optional<File> patternsFile = this.getPatternsFile();
        if (patternsFile.isPresent()) {
            this.importSequencePatterns(patternsFile.get(), s -> s.getHeader().substring(1));
        }
    }

    private void importSequenceIdentifiersPatterns() {
        Optional<File> patternsFile = this.getPatternsFile();
        if (patternsFile.isPresent()) {
            this.importSequencePatterns(patternsFile.get(), Sequence::getName);
        }
    }

    private void importSequencePatterns(File file, Function<Sequence, String> sequenceMapper) {
        try {
            SequencesGroup sequencesGroup = DatatypeFactory.getDefaultDatatypeFactory().newSequencesGroup(file.toPath());
            sequencesGroup.getSequences().map(sequenceMapper::apply).forEach(s -> this.addSequencePatternPanelComponent((String)s));
        }
        catch (RuntimeException e) {
            JOptionPane.showConfirmDialog(this, "The selected file can't be read as FASTA format.", "Error", -1, 0);
        }
    }

    private void notifyPatternAdded() {
        ChangeEvent event = new ChangeEvent(this);
        for (SequencePatternEditorListener l : this.getSequencePatternEditorListener()) {
            l.patternAdded(event);
        }
    }

    private void notifyPatternRemoved() {
        ChangeEvent event = new ChangeEvent(this);
        for (SequencePatternEditorListener l : this.getSequencePatternEditorListener()) {
            l.patternRemoved(event);
        }
    }

    private void notifyPatternEdited(PatternEditionEvent event) {
        for (SequencePatternEditorListener l : this.getSequencePatternEditorListener()) {
            l.patternEdited(event);
        }
    }

    private synchronized void checkComponentsPatternEvent(PatternEditionEvent event) {
        if (!event.getType().equals((Object)PatternEditionEvent.PatternEditionType.REGEX) && this.sequencePatternComponents.size() > 1) {
            if (EDIT_OTHER_PATTERNS_MESSAGE.shouldBeShown()) {
                int n = JOptionPane.showConfirmDialog(SwingUtilities.getRootPane(this), EDIT_OTHER_PATTERNS_MESSAGE.getMessage(), "Edit other patterns?", 0);
                lastEditOtherPatternsResponse = n == 0;
            }
            if (lastEditOtherPatternsResponse) {
                this.ignorePatternEditionEvents = true;
                switch (event.getType()) {
                    case CASE_SENSITIVE: {
                        this.setOtherPanelsCaseSensitiveFrom((SequencePatternPanel)event.getSource());
                        break;
                    }
                    case MODE: {
                        this.setOtherPanelsContainsRegexFrom((SequencePatternPanel)event.getSource());
                        break;
                    }
                    case REGEX: {
                        break;
                    }
                    case REQUIRED_MATCHES: {
                        this.setOtherPanelsRequiredMatchesFrom((SequencePatternPanel)event.getSource());
                    }
                }
                this.ignorePatternEditionEvents = false;
                this.notifyPatternEdited(new PatternEditionEvent(this, event.getType()));
            }
        }
    }

    private void setOtherPanelsContainsRegexFrom(SequencePatternPanel sourcePanel) {
        boolean containsRegex = sourcePanel.getSequencePattern().isContainsRegex();
        this.sequencePatternComponents.stream().map(SequencePatternPanelComponent::getSequencePatternPanel).filter(panel -> !panel.equals(sourcePanel)).forEach(p -> p.setContainsRegex(containsRegex));
    }

    private void setOtherPanelsCaseSensitiveFrom(SequencePatternPanel sourcePanel) {
        boolean caseSensitive = sourcePanel.getSequencePattern().isCaseSensitive();
        this.sequencePatternComponents.stream().map(SequencePatternPanelComponent::getSequencePatternPanel).filter(panel -> !panel.equals(sourcePanel)).forEach(p -> p.setCaseSensitive(caseSensitive));
    }

    private void setOtherPanelsRequiredMatchesFrom(SequencePatternPanel sourcePanel) {
        int requiredMatches = sourcePanel.getSequencePattern().getRequiredNumberOfMatches();
        this.sequencePatternComponents.stream().map(SequencePatternPanelComponent::getSequencePatternPanel).filter(panel -> !panel.equals(sourcePanel)).forEach(p -> p.setRequiredNumberOfMatches(requiredMatches));
    }

    public boolean isValidUserSelection() {
        return this.sequencePatternComponents.size() > 0 && this.allPatternsAreValid();
    }

    private boolean allPatternsAreValid() {
        return !this.sequencePatternComponents.stream().map(SequencePatternPanelComponent::getSequencePatternPanel).map(SequencePatternPanel::isValidUserSelection).filter(valid -> valid == false).findAny().isPresent();
    }

    public SequencePatternGroup getSequencePatternGroup() {
        return new SequencePatternGroup(this.getSelectedMode(), this.getPatterns());
    }

    private EvaluableSequencePattern.GroupMode getSelectedMode() {
        return (EvaluableSequencePattern.GroupMode)((Object)this.patternsModeCombo.getSelectedItem());
    }

    private SequencePattern[] getPatterns() {
        return this.sequencePatternComponents.stream().map(SequencePatternPanelComponent::getSequencePatternPanel).map(SequencePatternPanel::getSequencePattern).collect(Collectors.toList()).toArray(new SequencePattern[this.sequencePatternComponents.size()]);
    }

    public synchronized void addSequencePatternEditorListener(SequencePatternEditorListener l) {
        this.listenerList.add(SequencePatternEditorListener.class, l);
    }

    public synchronized SequencePatternEditorListener[] getSequencePatternEditorListener() {
        return (SequencePatternEditorListener[])this.listenerList.getListeners(SequencePatternEditorListener.class);
    }

    private class SequencePatternPanelComponent
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private SequencePatternPanel sequencePatternPanel;

        SequencePatternPanelComponent(String pattern) {
            this.init();
            this.sequencePatternPanel.setPattern(pattern);
        }

        public SequencePatternPanelComponent(SequencePattern pattern) {
            this.init();
            this.sequencePatternPanel.setPattern(pattern.getRegex());
            this.sequencePatternPanel.setRequiredNumberOfMatches(pattern.getRequiredNumberOfMatches());
            this.sequencePatternPanel.setCaseSensitive(pattern.isCaseSensitive());
            this.sequencePatternPanel.setContainsRegex(pattern.isContainsRegex());
        }

        private void init() {
            this.setLayout(new FlowLayout());
            this.add(this.getSequencePatternPanel());
            this.add(this.getRemoveButton());
        }

        private JButton getRemoveButton() {
            JButton removeButton = new JButton("Remove");
            removeButton.addActionListener(event -> SequencePatternGroupPanel.this.removeSequencePatternComponent(this));
            return removeButton;
        }

        public SequencePatternPanel getSequencePatternPanel() {
            if (this.sequencePatternPanel == null) {
                this.sequencePatternPanel = new SequencePatternPanel();
                this.sequencePatternPanel.addSequencePatternEditorListener(new SequencePatternEditorAdapter(){

                    @Override
                    public void patternEdited(PatternEditionEvent event) {
                        if (!SequencePatternGroupPanel.this.ignorePatternEditionEvents) {
                            SequencePatternGroupPanel.this.notifyPatternEdited(event);
                            SwingUtilities.invokeLater(() -> SequencePatternGroupPanel.this.checkComponentsPatternEvent(event));
                        }
                    }
                });
            }
            return this.sequencePatternPanel;
        }
    }
}

