/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.gui.configuration_panel;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.sing_group.gc4s.event.DocumentAdapter;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.text.ExtendedJXTextField;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.gui.GuiUtils;
import org.sing_group.seda.gui.configuration_panel.ReformatFastaConfigurationPanel;
import org.sing_group.seda.plugin.core.info.plugin.MergeSedaPluginInfo;
import org.sing_group.seda.transformation.provider.merge.MergeTransformationProvider;

public class MergeConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ExtendedJXTextField nameTextField;
    private MergeTransformationProvider transformationProvider;
    private ReformatFastaConfigurationPanel reformatPanel;

    public MergeConfigurationPanel() {
        this.init();
        this.initTransformationProvider();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.getParametersPanel());
        mainPanel.add(this.getReformatFastaConfigurationPanel());
        return new CenteredJPanel((Component)mainPanel);
    }

    private JPanel getParametersPanel() {
        return new InputParametersPanel(new InputParameter[]{this.getInputParameters()});
    }

    private InputParameter getInputParameters() {
        this.nameTextField = new ExtendedJXTextField("Name");
        this.nameTextField.setColumns(20);
        this.nameTextField.setEmptyTextFieldColor(GuiUtils.COLOR_ERROR);
        this.nameTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void removeUpdate(DocumentEvent e) {
                MergeConfigurationPanel.this.nameChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                MergeConfigurationPanel.this.nameChanged();
            }
        });
        return new InputParameter("Name:", (JComponent)this.nameTextField, MergeSedaPluginInfo.PARAM_NAME_HELP_GUI);
    }

    private Component getReformatFastaConfigurationPanel() {
        this.reformatPanel = new ReformatFastaConfigurationPanel();
        this.reformatPanel.setBorder(BorderFactory.createTitledBorder("Reformat output file"));
        return this.reformatPanel;
    }

    private void nameChanged() {
        this.transformationProvider.setName(this.nameTextField.getText());
    }

    private void initTransformationProvider() {
        this.transformationProvider = new MergeTransformationProvider();
        this.transformationProvider.setReformatFastaTransformationProvider(this.reformatPanel.getTransformationProvider());
        this.transformationProvider.setName("");
    }

    public MergeTransformationProvider getTransformationProvider() {
        return this.transformationProvider;
    }

    public void setTransformationProvider(MergeTransformationProvider transformationProvider) {
        this.transformationProvider = transformationProvider;
        this.nameTextField.setText(this.transformationProvider.getName());
        this.reformatPanel.setTransformationProvider(this.transformationProvider.getReformatFastaTransformationProvider());
    }
}

