/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.core.operations;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;

public class BasePresence {
    @XmlElement
    protected double minimumPresence;
    @XmlElement
    protected double maximumPresence;
    @XmlElement
    protected List<Character> bases;

    public BasePresence() {
    }

    public BasePresence(double minimumPresence, double maximumPresence, char ... bases) {
        this.minimumPresence = minimumPresence;
        this.maximumPresence = maximumPresence;
        this.checkRange();
        this.bases = BasePresence.requireNonEmptyList(BasePresence.getBasesList(bases));
    }

    private void checkRange() {
        if (this.maximumPresence < this.minimumPresence) {
            throw new IllegalArgumentException("The maximum value should be equal or higher than the minimum value");
        }
    }

    protected static <T> List<T> requireNonEmptyList(List<T> bases) {
        if (bases.isEmpty()) {
            throw new IllegalArgumentException("The list can't be empty");
        }
        return bases;
    }

    protected static List<Character> getBasesList(char[] bases) {
        LinkedList<Character> toret = new LinkedList<Character>();
        new LinkedList();
        for (char b : bases) {
            toret.add(Character.valueOf(b));
        }
        return toret;
    }

    public double getMaximumPresence() {
        return this.maximumPresence;
    }

    public double getMinimumPresence() {
        return this.minimumPresence;
    }

    public List<Character> getBases() {
        return this.bases;
    }

    public String toString() {
        return "Base(s): " + this.bases.stream().map(Object::toString).collect(Collectors.joining()) + " [" + this.minimumPresence + " ," + this.maximumPresence + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bases == null ? 0 : this.bases.hashCode());
        long temp = Double.doubleToLongBits(this.maximumPresence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minimumPresence);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasePresence other = (BasePresence)obj;
        if (this.bases == null ? other.bases != null : !this.bases.equals(other.bases)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maximumPresence) != Double.doubleToLongBits(other.maximumPresence)) {
            return false;
        }
        return Double.doubleToLongBits(this.minimumPresence) == Double.doubleToLongBits(other.minimumPresence);
    }
}

