/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.comments;

import japa.parser.ast.comments.BlockComment;
import japa.parser.ast.comments.Comment;
import japa.parser.ast.comments.CommentsCollection;
import japa.parser.ast.comments.JavadocComment;
import japa.parser.ast.comments.LineComment;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class CommentsParser {
    private static final int COLUMNS_PER_TAB = 4;

    public CommentsCollection parse(String source) throws IOException, UnsupportedEncodingException {
        ByteArrayInputStream in = new ByteArrayInputStream(source.getBytes());
        return this.parse(in, "UTF-8");
    }

    public CommentsCollection parse(InputStream in, String encoding) throws IOException, UnsupportedEncodingException {
        int r;
        boolean lastWasASlashR = false;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        CommentsCollection comments = new CommentsCollection();
        int prevChar = 122;
        State state = State.CODE;
        Comment currentLineComment = null;
        BlockComment currentBlockComment = null;
        StringBuffer currentContent = null;
        int currLine = 1;
        int currCol = 1;
        while ((r = br.read()) != -1) {
            char c = (char)r;
            if (c == '\r') {
                lastWasASlashR = true;
            } else {
                if (c == '\n' && lastWasASlashR) {
                    lastWasASlashR = false;
                    continue;
                }
                lastWasASlashR = false;
            }
            switch (state) {
                case CODE: {
                    if (prevChar == 47 && c == '/') {
                        currentLineComment = new LineComment();
                        currentLineComment.setBeginLine(currLine);
                        currentLineComment.setBeginColumn(currCol - 1);
                        state = State.IN_LINE_COMMENT;
                        currentContent = new StringBuffer();
                        break;
                    }
                    if (prevChar != 47 || c != '*') break;
                    currentBlockComment = new BlockComment();
                    currentBlockComment.setBeginLine(currLine);
                    currentBlockComment.setBeginColumn(currCol - 1);
                    state = State.IN_BLOCK_COMMENT;
                    currentContent = new StringBuffer();
                    break;
                }
                case IN_LINE_COMMENT: {
                    if (c == '\n' || c == '\r') {
                        currentLineComment.setContent(currentContent.toString());
                        currentLineComment.setEndLine(currLine);
                        currentLineComment.setEndColumn(currCol);
                        comments.addComment((LineComment)currentLineComment);
                        state = State.CODE;
                        break;
                    }
                    currentContent.append(c);
                    break;
                }
                case IN_BLOCK_COMMENT: {
                    if (prevChar == 42 && c == '/') {
                        String content = currentContent.deleteCharAt(currentContent.toString().length() - 1).toString();
                        if (content.startsWith("*")) {
                            JavadocComment javadocComment = new JavadocComment();
                            javadocComment.setContent(content.substring(1));
                            javadocComment.setBeginLine(currentBlockComment.getBeginLine());
                            javadocComment.setBeginColumn(currentBlockComment.getBeginColumn());
                            javadocComment.setEndLine(currLine);
                            javadocComment.setEndColumn(currCol + 1);
                            comments.addComment(javadocComment);
                        } else {
                            currentBlockComment.setContent(content);
                            currentBlockComment.setEndLine(currLine);
                            currentBlockComment.setEndColumn(currCol + 1);
                            comments.addComment(currentBlockComment);
                        }
                        state = State.CODE;
                        break;
                    }
                    currentContent.append(c == '\r' ? (char)'\n' : (char)c);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected");
                }
            }
            switch (c) {
                case '\n': 
                case '\r': {
                    ++currLine;
                    currCol = 1;
                    break;
                }
                case '\t': {
                    currCol += 4;
                    break;
                }
                default: {
                    ++currCol;
                }
            }
            prevChar = c;
        }
        if (state == State.IN_LINE_COMMENT) {
            currentLineComment.setContent(currentContent.toString());
            currentLineComment.setEndLine(currLine);
            currentLineComment.setEndColumn(currCol);
            comments.addComment((LineComment)currentLineComment);
        }
        return comments;
    }

    private static enum State {
        CODE,
        WAITING_FOR_LINE_COMMENT,
        IN_LINE_COMMENT,
        WAITING_FOR_BLOCK_COMMENT,
        IN_BLOCK_COMMENT,
        WAITING_TO_LEAVE_BLOCK_COMMENT;

    }
}

