/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.gc4s.visualization.table;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class MapTableModel<K, V>
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private Map<K, V> map;
    private List<K> rows;

    public MapTableModel(Map<K, V> map) {
        this.map = map;
        this.rows = this.sortRows(this.map.keySet());
    }

    protected List<K> sortRows(Set<K> keys) {
        LinkedList<K> rows = new LinkedList<K>();
        rows.addAll(this.map.keySet());
        Collections.sort(rows, new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return rows;
    }

    @Override
    public int getRowCount() {
        return this.map.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Key" : "Value";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        K row = this.rows.get(rowIndex);
        return columnIndex == 0 ? row.toString() : this.map.get(row).toString();
    }
}

