/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.splign.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.DockerExecutionUtils;
import org.sing_group.seda.core.execution.DockerImageChecker;
import org.sing_group.seda.splign.execution.AbstractSplignCompartBinariesExecutor;
import org.sing_group.seda.splign.execution.SplignCompartEnvironment;

@XmlRootElement
public class DockerSplignCompartBinariesExecutor
extends AbstractSplignCompartBinariesExecutor {
    @XmlTransient
    private final SplignCompartEnvironment environment = SplignCompartEnvironment.getInstance();
    @XmlTransient
    private final DockerImageChecker dockerImageChecker = DockerImageChecker.getInstance();
    @XmlElement
    private final String dockerImage;

    public DockerSplignCompartBinariesExecutor() {
        this(DockerSplignCompartBinariesExecutor.getDefaultDockerImage());
    }

    public DockerSplignCompartBinariesExecutor(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    @Override
    protected String toFilePath(File file) {
        return DockerExecutionUtils.dockerPath(file.getAbsolutePath());
    }

    public static String getDefaultDockerImage() {
        return "singgroup/seda-splign-compart";
    }

    @Override
    public void checkBinary() throws BinaryCheckException {
        if (this.dockerImageChecker.shouldCheckDockerImage(this.dockerImage)) {
            DockerExecutionUtils.checkDockerAvailability();
            super.checkBinary();
            this.dockerImageChecker.storeImageTimestamp(this.dockerImage);
        }
    }

    @Override
    public void mklds(File path) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(path.getParent());
        LinkedList<String> parameters = new LinkedList<String>();
        parameters.addAll(DockerSplignCompartBinariesExecutor.composeSplignCompartCommand(this.dockerImage, directoriesToMount, ""));
        parameters.add("bash");
        parameters.add("-c");
        parameters.add(this.environment.getSplignCommand() + " -mklds " + this.toFilePath(path) + " && chmod -R 777 " + this.toFilePath(path) + "/_SplignLDS_");
        this.executeCommand(parameters);
    }

    @Override
    public void ldsdir(File ldsdir, File comps, File ldsdirFile) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(ldsdir.getAbsolutePath());
        directoriesToMount.add(comps.getParent());
        super.ldsdir(DockerSplignCompartBinariesExecutor.composeSplignCompartCommand(this.dockerImage, directoriesToMount, this.environment.getSplignCommand()), ldsdir, comps, ldsdirFile);
    }

    @Override
    public void compart(File qdb, File sdb, File compartmentsFile) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(qdb.getParent());
        directoriesToMount.add(sdb.getParent());
        directoriesToMount.add(compartmentsFile.getParent());
        super.compart(DockerSplignCompartBinariesExecutor.composeSplignCompartCommand(this.dockerImage, directoriesToMount, this.environment.getCompartCommand()), qdb, sdb, compartmentsFile);
    }

    @Override
    protected String composeCommand(String command) {
        return DockerSplignCompartBinariesExecutor.composeProSplignCompartCommand(this.dockerImage, command);
    }

    private static String composeProSplignCompartCommand(String proSplignCompart, String command) {
        return "docker run --rm " + proSplignCompart + " " + command;
    }

    private static List<String> composeSplignCompartCommand(String proSplignCompart, Set<String> directoriesToMount, String command) {
        return Arrays.asList(("docker run --rm " + DockerExecutionUtils.getMountDockerDirectoriesString(directoriesToMount) + " " + proSplignCompart + (command.isEmpty() ? "" : " ") + command).split(" "));
    }

    public String getDockerImage() {
        return this.dockerImage;
    }
}

