/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.transformation.provider;

import java.util.LinkedList;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutor;
import org.sing_group.seda.bedtools.execution.BedToolsBinariesExecutorWrapper;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.datatype.DatatypeFactory;
import org.sing_group.seda.plugin.spi.AbstractTransformationProvider;
import org.sing_group.seda.plugin.spi.DefaultValidation;
import org.sing_group.seda.plugin.spi.Validation;
import org.sing_group.seda.sapp.datatype.SappCodon;
import org.sing_group.seda.sapp.datatype.SappSpecies;
import org.sing_group.seda.sapp.execution.SappBinariesExecutor;
import org.sing_group.seda.sapp.transformation.provider.SappAnnotationTransformationConfigurationChangeType;
import org.sing_group.seda.sapp.transformation.sequencesgroup.SappAnnotationSequencesGroupTransformation;
import org.sing_group.seda.transformation.dataset.ComposedSequencesGroupDatasetTransformation;
import org.sing_group.seda.transformation.dataset.SequencesGroupDatasetTransformation;

@XmlRootElement
public class SappAnnotationTransformationProvider
extends AbstractTransformationProvider {
    @XmlAnyElement(lax=true)
    private SappBinariesExecutor sappBinariesExecutor;
    @XmlElement
    private BedToolsBinariesExecutorWrapper bedToolsBinariesExecutor;
    @XmlElement
    private SappCodon sappCodon;
    @XmlElement
    private SappSpecies sappSpecies;

    public SappAnnotationTransformationProvider() {
        this(SappSpecies.HOMO_SAPIENS, SappCodon.STANDARD);
    }

    public SappAnnotationTransformationProvider(SappSpecies sappSpecies, SappCodon sappCodon) {
        this.sappSpecies = sappSpecies;
        this.sappCodon = sappCodon;
        this.bedToolsBinariesExecutor = new BedToolsBinariesExecutorWrapper();
    }

    @Override
    public Validation validate() {
        try {
            LinkedList<String> validationErrors = new LinkedList<String>();
            if (this.sappSpecies == null) {
                validationErrors.add("The species mode can't be null");
            }
            if (this.sappCodon == null) {
                validationErrors.add("The codon can't be null");
            }
            if (!this.isValidSappBinariesExecutor()) {
                validationErrors.add("The SAPP binaries executor is not valid");
            }
            if (!this.isValidBedToolsBinariesExecutor()) {
                validationErrors.add("The bedtools binaries executor is not valid");
            }
            if (validationErrors.isEmpty()) {
                this.getTransformation(DatatypeFactory.getDefaultDatatypeFactory());
                return new DefaultValidation(new String[0]);
            }
            return new DefaultValidation(validationErrors);
        }
        catch (RuntimeException ex) {
            return new DefaultValidation(ex.toString());
        }
    }

    private boolean isValidSappBinariesExecutor() {
        if (this.sappBinariesExecutor == null) {
            return false;
        }
        try {
            this.sappBinariesExecutor.checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    private boolean isValidBedToolsBinariesExecutor() {
        if (this.bedToolsBinariesExecutor.get() == null) {
            return false;
        }
        try {
            this.bedToolsBinariesExecutor.get().checkBinary();
            return true;
        }
        catch (BinaryCheckException e) {
            return false;
        }
    }

    @Override
    public SequencesGroupDatasetTransformation getTransformation(DatatypeFactory factory) {
        return new ComposedSequencesGroupDatasetTransformation(this.getSappAnnotationTransformation(factory));
    }

    private SappAnnotationSequencesGroupTransformation getSappAnnotationTransformation(DatatypeFactory factory) {
        return new SappAnnotationSequencesGroupTransformation(factory, this.sappBinariesExecutor, this.bedToolsBinariesExecutor.get(), this.sappCodon, this.sappSpecies);
    }

    public void setSappBinariesExecutor(Optional<SappBinariesExecutor> sappBinariesExecutor) {
        this.sappBinariesExecutor = sappBinariesExecutor.orElse(null);
        this.fireTransformationsConfigurationModelEvent(SappAnnotationTransformationConfigurationChangeType.SAPP_EXECUTOR_CHANGED, this.sappBinariesExecutor);
    }

    public SappBinariesExecutor getSappBinariesExecutor() {
        return this.sappBinariesExecutor;
    }

    public void setBedToolsBinariesExecutor(Optional<BedToolsBinariesExecutor> bedToolsBinariesExecutor) {
        this.bedToolsBinariesExecutor.set((BedToolsBinariesExecutor)bedToolsBinariesExecutor.orElse(null));
        this.fireTransformationsConfigurationModelEvent(SappAnnotationTransformationConfigurationChangeType.BEDTOOLS_EXECUTOR_CHANGED, this.bedToolsBinariesExecutor.get());
    }

    public BedToolsBinariesExecutor getBedToolsBinariesExecutor() {
        return this.bedToolsBinariesExecutor.get();
    }

    public void setSappSpecies(SappSpecies sappSpecies) {
        if (this.sappSpecies == null || !this.sappSpecies.equals((Object)sappSpecies)) {
            this.sappSpecies = sappSpecies;
            this.fireTransformationsConfigurationModelEvent(SappAnnotationTransformationConfigurationChangeType.SAPP_SPECIES_CHANGED, (Object)this.sappSpecies);
        }
    }

    public SappSpecies getSappSpecies() {
        return this.sappSpecies;
    }

    public void setSappCodon(SappCodon sappCodon) {
        if (this.sappCodon == null || !this.sappCodon.equals((Object)sappCodon)) {
            this.sappCodon = sappCodon;
            this.fireTransformationsConfigurationModelEvent(SappAnnotationTransformationConfigurationChangeType.SAPP_CODON_CHANGED, (Object)this.sappCodon);
        }
    }

    public SappCodon getSappCodon() {
        return this.sappCodon;
    }
}

