/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.gui.execution;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeEvent;
import org.sing_group.gc4s.input.InputParameter;
import org.sing_group.gc4s.input.InputParametersPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanel;
import org.sing_group.gc4s.input.filechooser.JFileChooserPanelBuilder;
import org.sing_group.gc4s.input.filechooser.SelectionMode;
import org.sing_group.gc4s.ui.CenteredJPanel;
import org.sing_group.seda.sapp.execution.SappCommands;
import org.sing_group.seda.sapp.gui.execution.AbstractSappCommandsConfigurationPanel;
import org.sing_group.seda.sapp.plugin.core.SappAnnotationSedaPluginInfo;

public class SystemSappCommandsConfigurationPanel
extends AbstractSappCommandsConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private InputParametersPanel parametersPanel;
    private JFileChooserPanel javaPath;
    protected JFileChooserPanel sappJarsPath;
    private File selectedJavaPath;
    private File selectedSappJarsPath;

    public SystemSappCommandsConfigurationPanel() {
        this("", "");
    }

    public SystemSappCommandsConfigurationPanel(String javaPath, String sappJarsPath) {
        this.init(javaPath, sappJarsPath);
    }

    private void init(String javaPath, String sappJarsPath) {
        this.setLayout(new BorderLayout());
        this.add((Component)new CenteredJPanel(this.getParametersPanel(javaPath, sappJarsPath)));
    }

    private Component getParametersPanel(String javaPath, String sappJarsPath) {
        if (this.parametersPanel == null) {
            this.parametersPanel = new InputParametersPanel(this.getParameters(javaPath, sappJarsPath));
        }
        return this.parametersPanel;
    }

    private InputParameter[] getParameters(String javaPath, String sappJarsPath) {
        LinkedList<InputParameter> parameters = new LinkedList<InputParameter>();
        parameters.add(this.getJavaPathParameter(javaPath));
        parameters.add(this.getSappJarsPathParameter(sappJarsPath));
        return parameters.toArray(new InputParameter[parameters.size()]);
    }

    private InputParameter getJavaPathParameter(String javaPath) {
        this.javaPath = JFileChooserPanelBuilder.createOpenJFileChooserPanel().withFileChooser(new JFileChooser()).withFileChooserSelectionMode(SelectionMode.DIRECTORIES).withLabel("").build();
        this.javaPath.addFileChooserListener(this::javaPathChanged);
        if (!javaPath.isEmpty()) {
            this.javaPath.setSelectedFile(new File(javaPath));
        }
        return new InputParameter("Java path: ", (JComponent)this.javaPath, SappAnnotationSedaPluginInfo.PARAM_JAVA_PATH_HELP_GUI);
    }

    private void javaPathChanged(ChangeEvent event) {
        File newValue = this.javaPath.getSelectedFile();
        this.firePropertyChange("commands.javapath", this.javaPath, newValue);
        this.selectedJavaPath = newValue;
    }

    @Override
    protected Optional<String> selectedJavaPath() {
        if (this.selectedJavaPath == null) {
            return Optional.empty();
        }
        return Optional.of(this.selectedJavaPath.getAbsolutePath());
    }

    protected InputParameter getSappJarsPathParameter(String sappJarsPath) {
        this.sappJarsPath = JFileChooserPanelBuilder.createOpenJFileChooserPanel().withFileChooser(new JFileChooser()).withFileChooserSelectionMode(SelectionMode.DIRECTORIES).withLabel("").build();
        if (!sappJarsPath.isEmpty()) {
            this.sappJarsPath.setSelectedFile(new File(sappJarsPath));
        }
        this.sappJarsPath.addFileChooserListener(this::sappJarsPathChanged);
        return new InputParameter("SAPP jars path: ", (JComponent)this.sappJarsPath, SappAnnotationSedaPluginInfo.PARAM_SAPP_JARS_PATH_HELP_GUI);
    }

    private void sappJarsPathChanged(ChangeEvent event) {
        File newValue = this.sappJarsPath.getSelectedFile();
        this.firePropertyChange("commands.sappjarspath", this.selectedSappJarsPath, newValue);
        this.selectedSappJarsPath = newValue;
    }

    @Override
    protected Optional<String> selectedSappJarsPath() {
        if (this.selectedSappJarsPath == null) {
            return Optional.empty();
        }
        return Optional.of(this.selectedSappJarsPath.getAbsolutePath());
    }

    public void setControlsEnabled(boolean enabled) {
        this.javaPath.getBrowseAction().setEnabled(enabled);
        this.sappJarsPath.getBrowseAction().setEnabled(enabled);
    }

    public void setSappCommands(SappCommands sappCommands) {
        File javaPathParentFile = new File(sappCommands.javaExecutablePath()).getParentFile();
        if (javaPathParentFile != null) {
            this.javaPath.setSelectedFile(javaPathParentFile);
        } else {
            this.javaPath.clearSelectedFile();
        }
        this.sappJarsPath.setSelectedFile(new File(sappCommands.jarsPath()));
    }
}

