/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.execution;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;

public class SappGff3Parser {
    private File source;

    public SappGff3Parser(File source) {
        this.source = source;
    }

    public void extractCdsRegionsByGeneToFile(File dest) throws IOException {
        HashMap<String, Integer> geneBySequenceCount = new HashMap<String, Integer>();
        String originalSequence = null;
        LinkedList<String> cdsLines = new LinkedList<String>();
        Integer currentGene = null;
        for (String line : Files.readAllLines(this.source.toPath())) {
            if (line.startsWith("# start gene g")) {
                currentGene = geneBySequenceCount.getOrDefault(originalSequence, 0) + 1;
                geneBySequenceCount.put(originalSequence, currentGene);
                continue;
            }
            if (line.startsWith("# ----- prediction on sequence number")) {
                int start = line.indexOf("name = ") + 7;
                originalSequence = line.substring(start, line.indexOf(")", start));
                continue;
            }
            if (line.startsWith("#") || !line.contains("\tCDS\t")) continue;
            if (originalSequence == null) {
                throw new IllegalStateException("# ----- prediction on sequence number before first GFF3 line.");
            }
            if (currentGene == null) {
                throw new IllegalStateException("# start gene line not found before first GFF3 line.");
            }
            String gffLine = line.replace("\tCDS\t", "\t" + originalSequence + "_" + currentGene + "\t");
            cdsLines.add(gffLine);
        }
        Files.write(dest.toPath(), cdsLines.stream().collect(Collectors.joining("\n", "", "\n")).getBytes(), new OpenOption[0]);
    }
}

