/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.sapp.execution;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.core.execution.DockerExecutionUtils;
import org.sing_group.seda.core.execution.DockerImageChecker;
import org.sing_group.seda.sapp.datatype.SappCodon;
import org.sing_group.seda.sapp.datatype.SappSpecies;
import org.sing_group.seda.sapp.execution.AbstractSappBinariesExecutor;
import org.sing_group.seda.sapp.execution.DefaultDockerSappCommands;
import org.sing_group.seda.sapp.execution.DockerSappCommands;

@XmlRootElement
public class DockerSappBinariesExecutor
extends AbstractSappBinariesExecutor {
    @XmlTransient
    private final DockerImageChecker dockerImageChecker = DockerImageChecker.getInstance();
    @XmlAnyElement(lax=true)
    private final DockerSappCommands configuration;

    public DockerSappBinariesExecutor() {
        this(new DefaultDockerSappCommands());
    }

    public DockerSappBinariesExecutor(DockerSappCommands configuration) {
        this.configuration = configuration;
    }

    @Override
    public void fasta2hdt(File input, File output, String sampleIdentifier, SappCodon sappCodon, SappSpecies sappSpecies, String additionalParameters) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(input.getParent());
        directoriesToMount.add(output.getParent());
        super.fasta2hdt(this.composeCommand(directoriesToMount, this.configuration.conversion()), input, output, sampleIdentifier, sappCodon, sappSpecies, additionalParameters);
    }

    @Override
    public void augustus(File input, File output, SappCodon sappCodon, SappSpecies sappSpecies) throws IOException, InterruptedException {
        HashSet<String> directoriesToMount = new HashSet<String>();
        directoriesToMount.add(input.getParent());
        directoriesToMount.add(output.getParent());
        super.augustus(this.composeCommand(directoriesToMount, this.configuration.geneCaller()), input, output, sappCodon, sappSpecies);
    }

    @Override
    protected String getConversionCommand() {
        return this.composeCommand(this.configuration.conversion());
    }

    @Override
    protected String getGeneCallerCommand() {
        return this.composeCommand(this.configuration.geneCaller());
    }

    @Override
    public void checkBinary() throws BinaryCheckException {
        if (this.dockerImageChecker.shouldCheckDockerImage(this.configuration.dockerImage())) {
            DockerExecutionUtils.checkDockerAvailability();
            super.checkBinary();
            this.dockerImageChecker.storeImageTimestamp(this.configuration.dockerImage());
        }
    }

    @Override
    protected String toFilePath(File file) {
        return DockerExecutionUtils.dockerPath(file.getAbsolutePath());
    }

    private String composeCommand(String command) {
        return "docker run --rm " + this.configuration.dockerImage() + " " + command;
    }

    private List<String> composeCommand(Set<String> directoriesToMount, String command) {
        return Arrays.asList(("docker run --rm " + DockerExecutionUtils.getMountDockerDirectoriesString(directoriesToMount) + " " + this.configuration.dockerImage() + " " + command).split(" "));
    }

    public DockerSappCommands getDockerSappCommands() {
        return this.configuration;
    }
}

