/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.pfam;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.sing_group.seda.datatype.Sequence;
import org.sing_group.seda.pfam.PfamScanAnnotations;
import org.sing_group.seda.pfam.PfamScanBatchResult;
import org.sing_group.seda.pfam.PfamScanRequest;
import org.sing_group.seda.pfam.PfamScanRequestConfiguration;
import org.sing_group.seda.pfam.PfamScanStatus;

public class PfamScanBatch {
    private static final int DELAY_STATUS_RETRY = 15;
    private PfamScanRequestConfiguration config;
    private List<Sequence> sequences;

    public PfamScanBatch(PfamScanRequestConfiguration config, List<Sequence> sequences) {
        this.config = config;
        this.sequences = sequences;
    }

    public CompletableFuture<PfamScanBatchResult> query() {
        return CompletableFuture.supplyAsync(this::processSequences);
    }

    private PfamScanBatchResult processSequences() {
        final ConcurrentHashMap<Sequence, PfamScanAnnotations> annotations = new ConcurrentHashMap<Sequence, PfamScanAnnotations>();
        final LinkedList<Sequence> errors = new LinkedList<Sequence>();
        LinkedList<Thread> threads = new LinkedList<Thread>();
        for (final Sequence sequence : this.sequences) {
            Thread t2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    PfamScanRequest request = new PfamScanRequest(sequence, PfamScanBatch.this.config);
                    try {
                        request.query();
                        while (request.getStatus().isAlive()) {
                            TimeUnit.SECONDS.sleep(15L);
                        }
                        if (!request.getStatus().equals((Object)PfamScanStatus.FINISHED)) {
                            throw new RuntimeException("Error analyzing " + sequence.getName() + ". Status: " + (Object)((Object)request.getStatus()) + ". Request ID: " + request.getRequestId().get());
                        }
                        annotations.put(sequence, request.getResult());
                    }
                    catch (IOException | InterruptedException e) {
                        e.printStackTrace();
                        errors.add(sequence);
                    }
                }
            });
            threads.add(t2);
            t2.start();
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        threads.forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        return new PfamScanBatchResult(annotations, errors);
    }
}

