/*
 * Decompiled with CFR 0.152.
 */
package japa.parser.ast.visitor;

import japa.parser.Position;
import japa.parser.PositionUtils;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.Node;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.TypeParameter;
import japa.parser.ast.body.AnnotationDeclaration;
import japa.parser.ast.body.AnnotationMemberDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EmptyMemberDeclaration;
import japa.parser.ast.body.EmptyTypeDeclaration;
import japa.parser.ast.body.EnumConstantDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.InitializerDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.ModifierSet;
import japa.parser.ast.body.MultiTypeParameter;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.comments.BlockComment;
import japa.parser.ast.comments.Comment;
import japa.parser.ast.comments.JavadocComment;
import japa.parser.ast.comments.LineComment;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayAccessExpr;
import japa.parser.ast.expr.ArrayCreationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.AssignExpr;
import japa.parser.ast.expr.BinaryExpr;
import japa.parser.ast.expr.BooleanLiteralExpr;
import japa.parser.ast.expr.CastExpr;
import japa.parser.ast.expr.CharLiteralExpr;
import japa.parser.ast.expr.ClassExpr;
import japa.parser.ast.expr.ConditionalExpr;
import japa.parser.ast.expr.DoubleLiteralExpr;
import japa.parser.ast.expr.EnclosedExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.FieldAccessExpr;
import japa.parser.ast.expr.InstanceOfExpr;
import japa.parser.ast.expr.IntegerLiteralExpr;
import japa.parser.ast.expr.IntegerLiteralMinValueExpr;
import japa.parser.ast.expr.LongLiteralExpr;
import japa.parser.ast.expr.LongLiteralMinValueExpr;
import japa.parser.ast.expr.MarkerAnnotationExpr;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.NullLiteralExpr;
import japa.parser.ast.expr.ObjectCreationExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.SingleMemberAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.expr.SuperExpr;
import japa.parser.ast.expr.ThisExpr;
import japa.parser.ast.expr.UnaryExpr;
import japa.parser.ast.expr.VariableDeclarationExpr;
import japa.parser.ast.stmt.AssertStmt;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.BreakStmt;
import japa.parser.ast.stmt.CatchClause;
import japa.parser.ast.stmt.ContinueStmt;
import japa.parser.ast.stmt.DoStmt;
import japa.parser.ast.stmt.EmptyStmt;
import japa.parser.ast.stmt.ExplicitConstructorInvocationStmt;
import japa.parser.ast.stmt.ExpressionStmt;
import japa.parser.ast.stmt.ForStmt;
import japa.parser.ast.stmt.ForeachStmt;
import japa.parser.ast.stmt.IfStmt;
import japa.parser.ast.stmt.LabeledStmt;
import japa.parser.ast.stmt.ReturnStmt;
import japa.parser.ast.stmt.Statement;
import japa.parser.ast.stmt.SwitchEntryStmt;
import japa.parser.ast.stmt.SwitchStmt;
import japa.parser.ast.stmt.SynchronizedStmt;
import japa.parser.ast.stmt.ThrowStmt;
import japa.parser.ast.stmt.TryStmt;
import japa.parser.ast.stmt.TypeDeclarationStmt;
import japa.parser.ast.stmt.WhileStmt;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.VoidVisitor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class DumpVisitor
implements VoidVisitor<Object> {
    private final SourcePrinter printer = new SourcePrinter();

    public String getSource() {
        return this.printer.getSource();
    }

    private void printModifiers(int modifiers) {
        if (ModifierSet.isPrivate(modifiers)) {
            this.printer.print("private ");
        }
        if (ModifierSet.isProtected(modifiers)) {
            this.printer.print("protected ");
        }
        if (ModifierSet.isPublic(modifiers)) {
            this.printer.print("public ");
        }
        if (ModifierSet.isAbstract(modifiers)) {
            this.printer.print("abstract ");
        }
        if (ModifierSet.isStatic(modifiers)) {
            this.printer.print("static ");
        }
        if (ModifierSet.isFinal(modifiers)) {
            this.printer.print("final ");
        }
        if (ModifierSet.isNative(modifiers)) {
            this.printer.print("native ");
        }
        if (ModifierSet.isStrictfp(modifiers)) {
            this.printer.print("strictfp ");
        }
        if (ModifierSet.isSynchronized(modifiers)) {
            this.printer.print("synchronized ");
        }
        if (ModifierSet.isTransient(modifiers)) {
            this.printer.print("transient ");
        }
        if (ModifierSet.isVolatile(modifiers)) {
            this.printer.print("volatile ");
        }
    }

    private void printMembers(List<BodyDeclaration> members, Object arg) {
        for (BodyDeclaration member : members) {
            this.printer.printLn();
            member.accept(this, arg);
            this.printer.printLn();
        }
    }

    private void printMemberAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            for (AnnotationExpr a : annotations) {
                a.accept(this, arg);
                this.printer.printLn();
            }
        }
    }

    private void printAnnotations(List<AnnotationExpr> annotations, Object arg) {
        if (annotations != null) {
            for (AnnotationExpr a : annotations) {
                a.accept(this, arg);
                this.printer.print(" ");
            }
        }
    }

    private void printTypeArgs(List<Type> args, Object arg) {
        if (args != null) {
            this.printer.print("<");
            Iterator<Type> i = args.iterator();
            while (i.hasNext()) {
                Type t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printTypeParameters(List<TypeParameter> args, Object arg) {
        if (args != null) {
            this.printer.print("<");
            Iterator<TypeParameter> i = args.iterator();
            while (i.hasNext()) {
                TypeParameter t = i.next();
                t.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printArguments(List<Expression> args, Object arg) {
        this.printer.print("(");
        if (args != null) {
            Iterator<Expression> i = args.iterator();
            while (i.hasNext()) {
                Expression e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    private void printJavadoc(JavadocComment javadoc, Object arg) {
        if (javadoc != null) {
            javadoc.accept(this, arg);
        }
    }

    private void printJavaComment(Comment javacomment, Object arg) {
        if (javacomment != null) {
            javacomment.accept(this, arg);
        }
    }

    @Override
    public void visit(CompilationUnit n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getPackage() != null) {
            n.getPackage().accept(this, arg);
        }
        if (n.getImports() != null) {
            for (ImportDeclaration i : n.getImports()) {
                i.accept(this, arg);
            }
            this.printer.printLn();
        }
        if (n.getTypes() != null) {
            Iterator<TypeDeclaration> i = n.getTypes().iterator();
            while (i.hasNext()) {
                i.next().accept(this, arg);
                this.printer.printLn();
                if (!i.hasNext()) continue;
                this.printer.printLn();
            }
        }
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(PackageDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printer.print("package ");
        n.getName().accept(this, arg);
        this.printer.printLn(";");
        this.printer.printLn();
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(NameExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(QualifiedNameExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getQualifier().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getName());
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(ImportDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("import ");
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getName().accept(this, arg);
        if (n.isAsterisk()) {
            this.printer.print(".*");
        }
        this.printer.printLn(";");
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        ClassOrInterfaceType c;
        Iterator<ClassOrInterfaceType> i;
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        if (n.isInterface()) {
            this.printer.print("interface ");
        } else {
            this.printer.print("class ");
        }
        this.printer.print(n.getName());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            i = n.getExtends().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getImplements() != null) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getMembers() != null) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printOrphanCommentsEnding(n);
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EmptyTypeDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printer.print(";");
        this.printOrphanCommentsEnding(n);
    }

    @Override
    public void visit(JavadocComment n, Object arg) {
        this.printer.print("/**");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    @Override
    public void visit(ClassOrInterfaceType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print(n.getName());
        this.printTypeArgs(n.getTypeArgs(), arg);
    }

    @Override
    public void visit(TypeParameter n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        if (n.getTypeBound() != null) {
            this.printer.print(" extends ");
            Iterator<ClassOrInterfaceType> i = n.getTypeBound().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(" & ");
            }
        }
    }

    @Override
    public void visit(PrimitiveType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        switch (n.getType()) {
            case Boolean: {
                this.printer.print("boolean");
                break;
            }
            case Byte: {
                this.printer.print("byte");
                break;
            }
            case Char: {
                this.printer.print("char");
                break;
            }
            case Double: {
                this.printer.print("double");
                break;
            }
            case Float: {
                this.printer.print("float");
                break;
            }
            case Int: {
                this.printer.print("int");
                break;
            }
            case Long: {
                this.printer.print("long");
                break;
            }
            case Short: {
                this.printer.print("short");
            }
        }
    }

    @Override
    public void visit(ReferenceType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getType().accept(this, arg);
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(WildcardType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("?");
        if (n.getExtends() != null) {
            this.printer.print(" extends ");
            n.getExtends().accept(this, arg);
        }
        if (n.getSuper() != null) {
            this.printer.print(" super ");
            n.getSuper().accept(this, arg);
        }
    }

    @Override
    public void visit(FieldDeclaration n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVariables().iterator();
        while (i.hasNext()) {
            VariableDeclarator var = i.next();
            var.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarator n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getId().accept(this, arg);
        if (n.getInit() != null) {
            this.printer.print(" = ");
            n.getInit().accept(this, arg);
        }
    }

    @Override
    public void visit(VariableDeclaratorId n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(ArrayInitializerExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("{");
        if (n.getValues() != null) {
            this.printer.print(" ");
            Iterator<Expression> i = n.getValues().iterator();
            while (i.hasNext()) {
                Expression expr = i.next();
                expr.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" ");
        }
        this.printer.print("}");
    }

    @Override
    public void visit(VoidType n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("void");
    }

    @Override
    public void visit(ArrayAccessExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getName().accept(this, arg);
        this.printer.print("[");
        n.getIndex().accept(this, arg);
        this.printer.print("]");
    }

    @Override
    public void visit(ArrayCreationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("new ");
        n.getType().accept(this, arg);
        if (n.getDimensions() != null) {
            for (Expression dim : n.getDimensions()) {
                this.printer.print("[");
                dim.accept(this, arg);
                this.printer.print("]");
            }
            for (int i = 0; i < n.getArrayCount(); ++i) {
                this.printer.print("[]");
            }
        } else {
            for (int i = 0; i < n.getArrayCount(); ++i) {
                this.printer.print("[]");
            }
            this.printer.print(" ");
            n.getInitializer().accept(this, arg);
        }
    }

    @Override
    public void visit(AssignExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getTarget().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case assign: {
                this.printer.print("=");
                break;
            }
            case and: {
                this.printer.print("&=");
                break;
            }
            case or: {
                this.printer.print("|=");
                break;
            }
            case xor: {
                this.printer.print("^=");
                break;
            }
            case plus: {
                this.printer.print("+=");
                break;
            }
            case minus: {
                this.printer.print("-=");
                break;
            }
            case rem: {
                this.printer.print("%=");
                break;
            }
            case slash: {
                this.printer.print("/=");
                break;
            }
            case star: {
                this.printer.print("*=");
                break;
            }
            case lShift: {
                this.printer.print("<<=");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>=");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>=");
            }
        }
        this.printer.print(" ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(BinaryExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getLeft().accept(this, arg);
        this.printer.print(" ");
        switch (n.getOperator()) {
            case or: {
                this.printer.print("||");
                break;
            }
            case and: {
                this.printer.print("&&");
                break;
            }
            case binOr: {
                this.printer.print("|");
                break;
            }
            case binAnd: {
                this.printer.print("&");
                break;
            }
            case xor: {
                this.printer.print("^");
                break;
            }
            case equals: {
                this.printer.print("==");
                break;
            }
            case notEquals: {
                this.printer.print("!=");
                break;
            }
            case less: {
                this.printer.print("<");
                break;
            }
            case greater: {
                this.printer.print(">");
                break;
            }
            case lessEquals: {
                this.printer.print("<=");
                break;
            }
            case greaterEquals: {
                this.printer.print(">=");
                break;
            }
            case lShift: {
                this.printer.print("<<");
                break;
            }
            case rSignedShift: {
                this.printer.print(">>");
                break;
            }
            case rUnsignedShift: {
                this.printer.print(">>>");
                break;
            }
            case plus: {
                this.printer.print("+");
                break;
            }
            case minus: {
                this.printer.print("-");
                break;
            }
            case times: {
                this.printer.print("*");
                break;
            }
            case divide: {
                this.printer.print("/");
                break;
            }
            case remainder: {
                this.printer.print("%");
            }
        }
        this.printer.print(" ");
        n.getRight().accept(this, arg);
    }

    @Override
    public void visit(CastExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("(");
        n.getType().accept(this, arg);
        this.printer.print(") ");
        n.getExpr().accept(this, arg);
    }

    @Override
    public void visit(ClassExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getType().accept(this, arg);
        this.printer.print(".class");
    }

    @Override
    public void visit(ConditionalExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getCondition().accept(this, arg);
        this.printer.print(" ? ");
        n.getThenExpr().accept(this, arg);
        this.printer.print(" : ");
        n.getElseExpr().accept(this, arg);
    }

    @Override
    public void visit(EnclosedExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("(");
        n.getInner().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(FieldAccessExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getScope().accept(this, arg);
        this.printer.print(".");
        this.printer.print(n.getField());
    }

    @Override
    public void visit(InstanceOfExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getExpr().accept(this, arg);
        this.printer.print(" instanceof ");
        n.getType().accept(this, arg);
    }

    @Override
    public void visit(CharLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("'");
        this.printer.print(n.getValue());
        this.printer.print("'");
    }

    @Override
    public void visit(DoubleLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(LongLiteralMinValueExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getValue());
    }

    @Override
    public void visit(StringLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("\"");
        this.printer.print(n.getValue());
        this.printer.print("\"");
    }

    @Override
    public void visit(BooleanLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(String.valueOf(n.getValue()));
    }

    @Override
    public void visit(NullLiteralExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("null");
    }

    @Override
    public void visit(ThisExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("this");
    }

    @Override
    public void visit(SuperExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getClassExpr() != null) {
            n.getClassExpr().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("super");
    }

    @Override
    public void visit(MethodCallExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printTypeArgs(n.getTypeArgs(), arg);
        this.printer.print(n.getName());
        this.printArguments(n.getArgs(), arg);
    }

    @Override
    public void visit(ObjectCreationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getScope() != null) {
            n.getScope().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("new ");
        this.printTypeArgs(n.getTypeArgs(), arg);
        n.getType().accept(this, arg);
        this.printArguments(n.getArgs(), arg);
        if (n.getAnonymousClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getAnonymousClassBody(), arg);
            this.printer.unindent();
            this.printer.print("}");
        }
    }

    @Override
    public void visit(UnaryExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        switch (n.getOperator()) {
            case positive: {
                this.printer.print("+");
                break;
            }
            case negative: {
                this.printer.print("-");
                break;
            }
            case inverse: {
                this.printer.print("~");
                break;
            }
            case not: {
                this.printer.print("!");
                break;
            }
            case preIncrement: {
                this.printer.print("++");
                break;
            }
            case preDecrement: {
                this.printer.print("--");
            }
        }
        n.getExpr().accept(this, arg);
        switch (n.getOperator()) {
            case posIncrement: {
                this.printer.print("++");
                break;
            }
            case posDecrement: {
                this.printer.print("--");
            }
        }
    }

    @Override
    public void visit(ConstructorDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        this.printer.print(n.getName());
        this.printer.print("(");
        if (n.getParameters() != null) {
            i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        if (n.getThrows() != null) {
            this.printer.print(" throws ");
            i = n.getThrows().iterator();
            while (i.hasNext()) {
                NameExpr name = (NameExpr)i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(" ");
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(MethodDeclaration n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printTypeParameters(n.getTypeParameters(), arg);
        if (n.getTypeParameters() != null) {
            this.printer.print(" ");
        }
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("(");
        if (n.getParameters() != null) {
            Iterator<Parameter> i = n.getParameters().iterator();
            while (i.hasNext()) {
                Parameter p = i.next();
                p.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        for (int i = 0; i < n.getArrayCount(); ++i) {
            this.printer.print("[]");
        }
        if (n.getThrows() != null) {
            this.printer.print(" throws ");
            Iterator<NameExpr> i = n.getThrows().iterator();
            while (i.hasNext()) {
                NameExpr name = i.next();
                name.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getBody() == null) {
            this.printer.print(";");
        } else {
            this.printer.print(" ");
            n.getBody().accept(this, arg);
        }
    }

    @Override
    public void visit(Parameter n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        if (n.isVarArgs()) {
            this.printer.print("...");
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
    }

    @Override
    public void visit(MultiTypeParameter n, Object arg) {
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        Iterator<Type> types = n.getTypes().iterator();
        types.next().accept(this, arg);
        while (types.hasNext()) {
            this.printer.print(" | ");
            types.next().accept(this, arg);
        }
        this.printer.print(" ");
        n.getId().accept(this, arg);
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.isThis()) {
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("this");
        } else {
            if (n.getExpr() != null) {
                n.getExpr().accept(this, arg);
                this.printer.print(".");
            }
            this.printTypeArgs(n.getTypeArgs(), arg);
            this.printer.print("super");
        }
        this.printArguments(n.getArgs(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        Iterator<VariableDeclarator> i = n.getVars().iterator();
        while (i.hasNext()) {
            VariableDeclarator v = i.next();
            v.accept(this, arg);
            if (!i.hasNext()) continue;
            this.printer.print(", ");
        }
    }

    @Override
    public void visit(TypeDeclarationStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getTypeDeclaration().accept(this, arg);
    }

    @Override
    public void visit(AssertStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("assert ");
        n.getCheck().accept(this, arg);
        if (n.getMessage() != null) {
            this.printer.print(" : ");
            n.getMessage().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(BlockStmt n, Object arg) {
        this.printOrphanCommentsBeforeThisChildNode(n);
        this.printJavaComment(n.getComment(), arg);
        this.printer.printLn("{");
        if (n.getStmts() != null) {
            this.printer.indent();
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
            this.printer.unindent();
        }
        this.printer.print("}");
    }

    @Override
    public void visit(LabeledStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getLabel());
        this.printer.print(": ");
        n.getStmt().accept(this, arg);
    }

    @Override
    public void visit(EmptyStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(ExpressionStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        n.getExpression().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SwitchStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("switch(");
        n.getSelector().accept(this, arg);
        this.printer.printLn(") {");
        if (n.getEntries() != null) {
            this.printer.indent();
            for (SwitchEntryStmt e : n.getEntries()) {
                e.accept(this, arg);
            }
            this.printer.unindent();
        }
        this.printer.print("}");
    }

    @Override
    public void visit(SwitchEntryStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        if (n.getLabel() != null) {
            this.printer.print("case ");
            n.getLabel().accept(this, arg);
            this.printer.print(":");
        } else {
            this.printer.print("default:");
        }
        this.printer.printLn();
        this.printer.indent();
        if (n.getStmts() != null) {
            for (Statement s : n.getStmts()) {
                s.accept(this, arg);
                this.printer.printLn();
            }
        }
        this.printer.unindent();
    }

    @Override
    public void visit(BreakStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("break");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(ReturnStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("return");
        if (n.getExpr() != null) {
            this.printer.print(" ");
            n.getExpr().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(EnumDeclaration n, Object arg) {
        Iterator<Node> i;
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("enum ");
        this.printer.print(n.getName());
        if (n.getImplements() != null) {
            this.printer.print(" implements ");
            i = n.getImplements().iterator();
            while (i.hasNext()) {
                ClassOrInterfaceType c = i.next();
                c.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getEntries() != null) {
            this.printer.printLn();
            i = n.getEntries().iterator();
            while (i.hasNext()) {
                EnumConstantDeclaration e = (EnumConstantDeclaration)i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (n.getMembers() != null) {
            this.printer.printLn(";");
            this.printMembers(n.getMembers(), arg);
        } else if (n.getEntries() != null) {
            this.printer.printLn();
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EnumConstantDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printer.print(n.getName());
        if (n.getArgs() != null) {
            this.printArguments(n.getArgs(), arg);
        }
        if (n.getClassBody() != null) {
            this.printer.printLn(" {");
            this.printer.indent();
            this.printMembers(n.getClassBody(), arg);
            this.printer.unindent();
            this.printer.printLn("}");
        }
    }

    @Override
    public void visit(EmptyMemberDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(InitializerDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        if (n.isStatic()) {
            this.printer.print("static ");
        }
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(IfStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("if (");
        n.getCondition().accept(this, arg);
        boolean thenBlock = n.getThenStmt() instanceof BlockStmt;
        if (thenBlock) {
            this.printer.print(") ");
        } else {
            this.printer.printLn(")");
            this.printer.indent();
        }
        n.getThenStmt().accept(this, arg);
        if (!thenBlock) {
            this.printer.unindent();
        }
        if (n.getElseStmt() != null) {
            if (thenBlock) {
                this.printer.print(" ");
            } else {
                this.printer.printLn();
            }
            boolean elseIf = n.getElseStmt() instanceof IfStmt;
            boolean elseBlock = n.getElseStmt() instanceof BlockStmt;
            if (elseIf || elseBlock) {
                this.printer.print("else ");
            } else {
                this.printer.printLn("else");
                this.printer.indent();
            }
            n.getElseStmt().accept(this, arg);
            if (!elseIf && !elseBlock) {
                this.printer.unindent();
            }
        }
    }

    @Override
    public void visit(WhileStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("while (");
        n.getCondition().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ContinueStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("continue");
        if (n.getId() != null) {
            this.printer.print(" ");
            this.printer.print(n.getId());
        }
        this.printer.print(";");
    }

    @Override
    public void visit(DoStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("do ");
        n.getBody().accept(this, arg);
        this.printer.print(" while (");
        n.getCondition().accept(this, arg);
        this.printer.print(");");
    }

    @Override
    public void visit(ForeachStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("for (");
        n.getVariable().accept(this, arg);
        this.printer.print(" : ");
        n.getIterable().accept(this, arg);
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ForStmt n, Object arg) {
        Expression e;
        Iterator<Expression> i;
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("for (");
        if (n.getInit() != null) {
            i = n.getInit().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print("; ");
        if (n.getCompare() != null) {
            n.getCompare().accept(this, arg);
        }
        this.printer.print("; ");
        if (n.getUpdate() != null) {
            i = n.getUpdate().iterator();
            while (i.hasNext()) {
                e = i.next();
                e.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(") ");
        n.getBody().accept(this, arg);
    }

    @Override
    public void visit(ThrowStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("throw ");
        n.getExpr().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SynchronizedStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("synchronized (");
        n.getExpr().accept(this, arg);
        this.printer.print(") ");
        n.getBlock().accept(this, arg);
    }

    @Override
    public void visit(TryStmt n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("try ");
        if (!n.getResources().isEmpty()) {
            this.printer.print("(");
            Iterator<VariableDeclarationExpr> resources = n.getResources().iterator();
            boolean first = true;
            while (resources.hasNext()) {
                this.visit(resources.next(), arg);
                if (resources.hasNext()) {
                    this.printer.print(";");
                    this.printer.printLn();
                    if (first) {
                        this.printer.indent();
                    }
                }
                first = false;
            }
            if (n.getResources().size() > 1) {
                this.printer.unindent();
            }
            this.printer.print(") ");
        }
        n.getTryBlock().accept(this, arg);
        if (n.getCatchs() != null) {
            for (CatchClause c : n.getCatchs()) {
                c.accept(this, arg);
            }
        }
        if (n.getFinallyBlock() != null) {
            this.printer.print(" finally ");
            n.getFinallyBlock().accept(this, arg);
        }
    }

    @Override
    public void visit(CatchClause n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(" catch (");
        n.getExcept().accept(this, arg);
        this.printer.print(") ");
        n.getCatchBlock().accept(this, arg);
    }

    @Override
    public void visit(AnnotationDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        this.printer.print("@interface ");
        this.printer.print(n.getName());
        this.printer.printLn(" {");
        this.printer.indent();
        if (n.getMembers() != null) {
            this.printMembers(n.getMembers(), arg);
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(AnnotationMemberDeclaration n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printJavadoc(n.getJavaDoc(), arg);
        this.printMemberAnnotations(n.getAnnotations(), arg);
        this.printModifiers(n.getModifiers());
        n.getType().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n.getName());
        this.printer.print("()");
        if (n.getDefaultValue() != null) {
            this.printer.print(" default ");
            n.getDefaultValue().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(MarkerAnnotationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
    }

    @Override
    public void visit(SingleMemberAnnotationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        n.getMemberValue().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(NormalAnnotationExpr n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print("@");
        n.getName().accept(this, arg);
        this.printer.print("(");
        if (n.getPairs() != null) {
            Iterator<MemberValuePair> i = n.getPairs().iterator();
            while (i.hasNext()) {
                MemberValuePair m = i.next();
                m.accept(this, arg);
                if (!i.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    @Override
    public void visit(MemberValuePair n, Object arg) {
        this.printJavaComment(n.getComment(), arg);
        this.printer.print(n.getName());
        this.printer.print(" = ");
        n.getValue().accept(this, arg);
    }

    @Override
    public void visit(LineComment n, Object arg) {
        this.printer.print("//");
        String tmp = n.getContent();
        tmp = tmp.replace('\r', ' ');
        tmp = tmp.replace('\n', ' ');
        this.printer.printLn(tmp);
    }

    @Override
    public void visit(BlockComment n, Object arg) {
        this.printer.print("/*");
        this.printer.print(n.getContent());
        this.printer.printLn("*/");
    }

    private Position before(Object ... things) {
        Node n = this.firstOf(things);
        if (n == null) {
            return Position.ABSOLUTE_START;
        }
        return Position.beginOf(n);
    }

    private Position after(Object ... things) {
        Node n = this.lastOf(things);
        if (n == null) {
            return Position.ABSOLUTE_START;
        }
        return Position.endOf(n);
    }

    private Node lastOf(Object ... things) {
        for (int i = things.length - 1; i >= 0; --i) {
            Object thing = things[i];
            if (thing == null) continue;
            if (thing instanceof Node) {
                return (Node)thing;
            }
            if (thing instanceof List) {
                List list = (List)thing;
                if (list.size() <= 0) continue;
                return (Node)list.get(list.size() - 1);
            }
            throw new RuntimeException("Wrong thing passed");
        }
        return null;
    }

    private Node firstOf(Object ... things) {
        for (Object thing : things) {
            if (thing == null) continue;
            if (thing instanceof Node) {
                return (Node)thing;
            }
            if (thing instanceof List) {
                List list = (List)thing;
                if (list.size() <= 0) continue;
                return (Node)list.get(0);
            }
            throw new RuntimeException("Wrong thing passed");
        }
        return null;
    }

    private Position endOf(List<Node> nodes) {
        Node lastNode = nodes.get(nodes.size() - 1);
        if (lastNode == null) {
            return Position.ABSOLUTE_START;
        }
        return Position.endOf(lastNode);
    }

    private Position startOf(List<Node> nodes) {
        Node firstNode = nodes.get(0);
        if (firstNode == null) {
            return Position.ABSOLUTE_END;
        }
        return Position.beginOf(firstNode);
    }

    private void printOrphanCommentsBetween(List<Comment> comments, Object arg, Position start, Position end) {
        this.printOrphanCommentsBetween(comments, arg, start.getLine(), start.getColumn(), end.getLine(), end.getColumn());
    }

    private void printOrphanCommentsBetween(List<Comment> comments, Object arg, int startLine, int startColumn, int endLine, int endColumn) {
        for (Comment comment : comments) {
            if (!comment.isPositionedAfter(startLine, startColumn) || !comment.isPositionedBefore(endLine, endColumn)) continue;
            this.printOrphanComment(comment, arg);
        }
    }

    private void printOrphanComment(Comment comment, Object arg) {
        comment.accept(this, arg);
    }

    private void printOrphanCommentsEnding(Node node) {
        LinkedList<Node> everything = new LinkedList<Node>();
        everything.addAll(node.getChildrenNodes());
        PositionUtils.sortByBeginPosition(everything);
        if (everything.size() == 0) {
            return;
        }
        int commentsAtEnd = 0;
        boolean findingComments = true;
        while (findingComments) {
            Node last = (Node)everything.get(everything.size() - 1 - commentsAtEnd);
            findingComments = last instanceof Comment;
            if (!findingComments) continue;
            ++commentsAtEnd;
        }
        for (int i = 0; i < commentsAtEnd; ++i) {
            ((Node)everything.get(everything.size() - commentsAtEnd + i)).accept(this, null);
        }
    }

    private void printOrphanCommentsBeforeThisChildNode(Node node) {
        int i;
        if (node instanceof Comment) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        LinkedList<Node> everything = new LinkedList<Node>();
        everything.addAll(parent.getChildrenNodes());
        PositionUtils.sortByBeginPosition(everything);
        int positionOfTheChild = -1;
        for (int i2 = 0; i2 < everything.size(); ++i2) {
            if (everything.get(i2) != node) continue;
            positionOfTheChild = i2;
        }
        if (positionOfTheChild == -1) {
            throw new RuntimeException("My index not found!!! " + node);
        }
        int positionOfPreviousChild = -1;
        for (i = positionOfTheChild - 1; i >= 0 && positionOfPreviousChild == -1; --i) {
            if (everything.get(i) instanceof Comment) continue;
            positionOfPreviousChild = i;
        }
        for (i = positionOfPreviousChild + 1; i < positionOfTheChild; ++i) {
            Node nodeToPrint = (Node)everything.get(i);
            if (!(nodeToPrint instanceof Comment)) {
                throw new RuntimeException("Expected comment, instead " + nodeToPrint.getClass() + ". Position of previous child: " + positionOfPreviousChild + ", position of child " + positionOfTheChild);
            }
            nodeToPrint.accept(this, null);
        }
    }

    private static class SourcePrinter {
        private int level = 0;
        private boolean indented = false;
        private final StringBuilder buf = new StringBuilder();

        private SourcePrinter() {
        }

        public void indent() {
            ++this.level;
        }

        public void unindent() {
            --this.level;
        }

        private void makeIndent() {
            for (int i = 0; i < this.level; ++i) {
                this.buf.append("    ");
            }
        }

        public void print(String arg) {
            if (!this.indented) {
                this.makeIndent();
                this.indented = true;
            }
            this.buf.append(arg);
        }

        public void printLn(String arg) {
            this.print(arg);
            this.printLn();
        }

        public void printLn() {
            this.buf.append("\n");
            this.indented = false;
        }

        public String getSource() {
            return this.buf.toString();
        }

        public String toString() {
            return this.getSource();
        }
    }
}

