/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.prosplign.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.sing_group.gc4s.ui.CardsPanel;
import org.sing_group.gc4s.ui.CardsPanelBuilder;
import org.sing_group.seda.gui.execution.BinaryConfigurationPanelListener;
import org.sing_group.seda.gui.execution.BinaryExecutionConfigurationPanel;
import org.sing_group.seda.prosplign.execution.DefaultProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.execution.DockerProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.execution.ProSplignCompartBinariesExecutor;
import org.sing_group.seda.prosplign.gui.DockerExecutionConfigurationPanel;
import org.sing_group.seda.prosplign.gui.SystemBinaryExecutionConfigurationPanel;

public class ProSplignCompartExecutionConfigurationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CARD_SYSTEM_BINARY = "System binary";
    private static final String CARD_DOCKER_IMAGE = "Docker image";
    private CardsPanel proSplignCompartExecutableCardsPanel;
    private BinaryConfigurationPanelListener<ProSplignCompartBinariesExecutor> proSplignCompartExecutorChanged;
    private SystemBinaryExecutionConfigurationPanel systemBinaryExecutionConfigurationPanel;
    private DockerExecutionConfigurationPanel dockerExecutionConfigurationPanel;

    public ProSplignCompartExecutionConfigurationPanel(BinaryConfigurationPanelListener<ProSplignCompartBinariesExecutor> binaryConfigurationPanelListener) {
        this.proSplignCompartExecutorChanged = binaryConfigurationPanelListener;
        this.init();
    }

    private void init() {
        this.systemBinaryExecutionConfigurationPanel = new SystemBinaryExecutionConfigurationPanel();
        this.systemBinaryExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.proSplignCompartExecutorChanged);
        this.dockerExecutionConfigurationPanel = new DockerExecutionConfigurationPanel();
        this.dockerExecutionConfigurationPanel.addBinaryConfigurationPanelListener(this.proSplignCompartExecutorChanged);
        CardsPanelBuilder builder = CardsPanelBuilder.newBuilder().withCard((Object)CARD_DOCKER_IMAGE, (Component)this.dockerExecutionConfigurationPanel).withSelectedCard(CARD_DOCKER_IMAGE).disableSelectionWithOneCard(true);
        if (!System.getProperty("seda.local.execution.enabled", "true").equals("false") && !System.getProperty("seda.local.execution.enabled.prosplignprocompart", "true").equals("false")) {
            builder = builder.withCard((Object)CARD_SYSTEM_BINARY, (Component)this.systemBinaryExecutionConfigurationPanel);
        }
        this.proSplignCompartExecutableCardsPanel = builder.withSelectionLabel("Execution mode").build();
        this.proSplignCompartExecutableCardsPanel.setBorder((Border)BorderFactory.createTitledBorder("ProSplign/ProCompart configuration"));
        this.proSplignCompartExecutableCardsPanel.addPropertyChangeListener("gc4s.cardspanel.visiblecard", this::proSplignCompartBinaryExecutorCardChanged);
        this.add((Component)this.proSplignCompartExecutableCardsPanel);
    }

    private void proSplignCompartBinaryExecutorCardChanged(PropertyChangeEvent event) {
        this.proSplignCompartExecutorChanged.onBinariesExecutorChanged(this.getSelectedCard());
    }

    public Optional<ProSplignCompartBinariesExecutor> getBinariesExecutor() {
        return this.getSelectedCard().getBinariesExecutor();
    }

    public BinaryExecutionConfigurationPanel<ProSplignCompartBinariesExecutor> getSelectedCard() {
        BinaryExecutionConfigurationPanel selectedCard = (BinaryExecutionConfigurationPanel)((Object)this.proSplignCompartExecutableCardsPanel.getSelectedCard());
        return selectedCard;
    }

    public void setBinariesExecutor(ProSplignCompartBinariesExecutor binariesExecutor) {
        if (binariesExecutor instanceof DockerProSplignCompartBinariesExecutor) {
            this.dockerExecutionConfigurationPanel.setSelectedDockerImage(((DockerProSplignCompartBinariesExecutor)binariesExecutor).getDockerImage());
            this.proSplignCompartExecutableCardsPanel.setSelectedCard((Object)CARD_DOCKER_IMAGE);
        } else if (binariesExecutor instanceof DefaultProSplignCompartBinariesExecutor) {
            File directory = ((DefaultProSplignCompartBinariesExecutor)binariesExecutor).getProSplignCompartDirectory();
            if (directory != null) {
                this.systemBinaryExecutionConfigurationPanel.setSelectedFile(directory);
            } else {
                this.systemBinaryExecutionConfigurationPanel.clearSelectedFile();
            }
            this.proSplignCompartExecutableCardsPanel.setSelectedCard((Object)CARD_SYSTEM_BINARY);
        } else {
            throw new IllegalStateException("Unknown ProSplignCompartBinariesExecutor implementation");
        }
    }
}

