/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.gui;

import java.util.Optional;
import javax.swing.JOptionPane;
import org.sing_group.seda.clustalomega.execution.ClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.execution.DockerClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.plugin.core.ClustalOmegaAlignmentSedaPluginInfo;
import org.sing_group.seda.core.execution.BinaryCheckException;
import org.sing_group.seda.gui.execution.AbstractDockerExecutionConfigurationPanel;

public class DockerExecutionConfigurationPanel
extends AbstractDockerExecutionConfigurationPanel<ClustalOmegaBinariesExecutor> {
    private static final long serialVersionUID = 1L;
    private static final String HELP_CLUSTAL_OMEGA_PATH = ClustalOmegaAlignmentSedaPluginInfo.PARAM_DOCKER_MODE_HELP_GUI;

    public DockerExecutionConfigurationPanel() {
        super(DockerClustalOmegaBinariesExecutor.getDefaultDockerImage(), HELP_CLUSTAL_OMEGA_PATH);
    }

    @Override
    protected void checkBinary() {
        try {
            Optional<ClustalOmegaBinariesExecutor> executor = this.getBinariesExecutor();
            if (executor.isPresent()) {
                this.getBinariesExecutor().get().checkBinary();
                JOptionPane.showMessageDialog(this.getParentForDialogs(), "Clustal Omega checked successfully.", "Check Clustal Omega", 1);
            }
        }
        catch (BinaryCheckException e) {
            JOptionPane.showMessageDialog(this.getParentForDialogs(), "Error checking Clustal Omega: " + e.getCommand() + ".", "Error checking Clustal Omega", 0);
        }
    }

    @Override
    public Optional<ClustalOmegaBinariesExecutor> getBinariesExecutor() {
        String selectedDockerImage = this.getSelectedDockerImage();
        if (selectedDockerImage.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DockerClustalOmegaBinariesExecutor(selectedDockerImage));
    }
}

