/*
 * Decompiled with CFR 0.152.
 */
package org.sing_group.seda.clustalomega.cli;

import es.uvigo.ei.sing.yacli.command.option.IntegerDefaultValuedStringConstructedOption;
import es.uvigo.ei.sing.yacli.command.option.Option;
import es.uvigo.ei.sing.yacli.command.option.StringOption;
import es.uvigo.ei.sing.yacli.command.parameter.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.sing_group.seda.cli.ExternalSoftwareExecutionCommand;
import org.sing_group.seda.clustalomega.execution.AbstractClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.execution.ClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.execution.DefaultClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.execution.DockerClustalOmegaBinariesExecutor;
import org.sing_group.seda.clustalomega.plugin.core.ClustalOmegaAlignmentSedaPluginInfo;
import org.sing_group.seda.clustalomega.transformation.provider.ClustalOmegaAlignmentTransformationProvider;
import org.sing_group.seda.core.io.JsonObjectReader;

public class ClustalOmegaAlignmentCommand
extends ExternalSoftwareExecutionCommand {
    public static final IntegerDefaultValuedStringConstructedOption OPTION_NUM_THREADS = new IntegerDefaultValuedStringConstructedOption("num-threads", "th", "Number of threads to use.", Integer.valueOf(1));
    public static final StringOption OPTION_ADDITIONAL_PARAMETERS = new StringOption("additional-parameters", "ad", "Additional parameters for the Clustal Omega command.", true, false);
    public static final StringOption OPTION_DOCKER_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "docker-mode", "dk", "The Clustal Omega docker image. By default, the official SEDA image for Clustal Omega is used. If you provide a custom image, you may also need to specify the Clustal Omega executable command inside the image, in case it is not defined as ENTRYPOINT.", true, true);
    public static final StringOption OPTION_LOCAL_MODE = new StringOption(SOFTWARE_EXECUTION_CATEGORY, "local-mode", "lc", "The Clustal Omega binary file. If the Clustal Omega binary is in the path (clustalo in Unix systems and clustalo.exe in Windows systems), then this can be empty and the Check binary would say that it is right.", true, true);

    public String getName() {
        return "clustal-align";
    }

    public String getDescriptiveName() {
        return "Clustal Omega Alignment";
    }

    public String getDescription() {
        return "Use Clustal Omega to align the input FASTA files.";
    }

    @Override
    protected String getSedaGroup() {
        return ClustalOmegaAlignmentSedaPluginInfo.GROUP;
    }

    @Override
    public ClustalOmegaAlignmentTransformationProvider getTransformation(Parameters parameters) {
        ClustalOmegaAlignmentTransformationProvider provider = new ClustalOmegaAlignmentTransformationProvider();
        if (parameters.hasOption((Option)OPTION_ADDITIONAL_PARAMETERS)) {
            provider.setAdditionalParameters(parameters.getSingleValueString((Option)OPTION_ADDITIONAL_PARAMETERS));
        }
        if (parameters.hasOption((Option)OPTION_NUM_THREADS)) {
            provider.setNumThreads((Integer)parameters.getSingleValue((Option)OPTION_NUM_THREADS));
        }
        provider.setBinariesExecutor(Optional.of(this.getClustalOmegaBinariesExecutor(parameters)));
        return provider;
    }

    public ClustalOmegaBinariesExecutor getClustalOmegaBinariesExecutor(Parameters parameters) {
        ClustalOmegaAlignmentCommand.validateSingleExecutionMode(parameters, OPTION_LOCAL_MODE, OPTION_DOCKER_MODE);
        AbstractClustalOmegaBinariesExecutor executor = new DockerClustalOmegaBinariesExecutor(DockerClustalOmegaBinariesExecutor.getDefaultDockerImage());
        if (parameters.hasOption((Option)OPTION_LOCAL_MODE)) {
            File clustalBinaryFile = new File(parameters.getSingleValueString((Option)OPTION_LOCAL_MODE));
            if (clustalBinaryFile.isFile()) {
                executor = new DefaultClustalOmegaBinariesExecutor(clustalBinaryFile);
            } else {
                ClustalOmegaAlignmentCommand.formattedValidationError("The Clustal binary file is not a file");
            }
        }
        if (parameters.hasOption((Option)OPTION_DOCKER_MODE)) {
            executor = new DockerClustalOmegaBinariesExecutor((String)parameters.getSingleValue((Option)OPTION_DOCKER_MODE));
        }
        return executor;
    }

    @Override
    protected Map<Option<?>, String> getLocalOptionsToEnablePropertyMap() {
        return ClustalOmegaAlignmentCommand.fromKeyValue(OPTION_LOCAL_MODE, "seda.local.execution.enabled.clustalomega");
    }

    @Override
    protected List<Option<?>> getLocalOptionsList() {
        return Arrays.asList(OPTION_LOCAL_MODE);
    }

    @Override
    protected List<Option<?>> createExternalSedaOptions() {
        return Arrays.asList(OPTION_NUM_THREADS, OPTION_ADDITIONAL_PARAMETERS, OPTION_DOCKER_MODE, OPTION_LOCAL_MODE);
    }

    @Override
    protected ClustalOmegaAlignmentTransformationProvider getTransformation(File parametersFile) throws IOException {
        return (ClustalOmegaAlignmentTransformationProvider)new JsonObjectReader().read(parametersFile, ClustalOmegaAlignmentTransformationProvider.class);
    }
}

