/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.github.tomakehurst.wiremock.matching.AdvancedPathPattern;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.io.IOException;

public abstract class PathPatternJsonSerializer<T extends PathPattern>
extends JsonSerializer<T> {
    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        if (((PathPattern)value).isSimple()) {
            gen.writeStringField(((StringValuePattern)value).getName(), ((StringValuePattern)value).getExpected());
        } else {
            AdvancedPathPattern advancedPathPattern = new AdvancedPathPattern(((StringValuePattern)value).getExpected(), ((PathPattern)value).getValuePattern());
            gen.writeFieldName(((StringValuePattern)value).getName());
            JavaType javaType = serializers.getConfig().constructType(advancedPathPattern.getClass());
            JsonSerializer serializer = BeanSerializerFactory.instance.createSerializer(serializers, javaType);
            serializer.serialize((Object)advancedPathPattern, gen, serializers);
        }
        this.serializeAdditionalFields(value, gen, serializers);
        gen.writeEndObject();
    }

    protected abstract void serializeAdditionalFields(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;
}

