/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.util;

import com.sun.codemodel.JClass;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import com.sun.xml.bind.api.impl.NameConverter;
import java.util.Iterator;
import org.jvnet.jaxb2_commons.util.CodeModelUtils;

public class OutlineUtils {
    private OutlineUtils() {
    }

    public static String getClassName(ClassOutline classOutline) {
        return CodeModelUtils.getPackagedClassName((JClass)classOutline.implClass);
    }

    public static String getFieldName(FieldOutline fieldOutline) {
        return OutlineUtils.getClassName(fieldOutline.parent()) + "." + fieldOutline.getPropertyInfo().getName(true);
    }

    public static String getPropertyName(FieldOutline fieldOutline) {
        return NameConverter.standard.toVariableName(fieldOutline.getPropertyInfo().getName(true));
    }

    public static String getContextPath(Outline context) {
        StringBuilder sb = new StringBuilder();
        Iterator packageOutlines = context.getAllPackageContexts().iterator();
        while (packageOutlines.hasNext()) {
            PackageOutline packageOutline = (PackageOutline)packageOutlines.next();
            String packageName = packageOutline._package().name();
            sb.append(packageName);
            if (!packageOutlines.hasNext()) continue;
            sb.append(':');
        }
        return sb.toString();
    }
}

