/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.tool;

import java.util.concurrent.Callable;
import uk.ac.ebi.uniprot.parser.UniprotLineParser;
import uk.ac.ebi.uniprot.parser.UniprotLineParserFactory;
import uk.ac.ebi.uniprot.parser.impl.DefaultUniprotLineParserFactory;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObject;

public class ParsingJob
implements Callable<EntryObject> {
    private final String rawString;
    private static UniprotLineParserFactory parserFactory = new DefaultUniprotLineParserFactory();
    private static ThreadLocal<UniprotLineParser<EntryObject>> parsers = new ThreadLocal();

    public ParsingJob(String rawString) {
        this.rawString = rawString;
    }

    @Override
    public EntryObject call() throws Exception {
        UniprotLineParser<EntryObject> parser = parsers.get();
        if (parser == null) {
            parser = parserFactory.createEntryParser();
            parsers.set(parser);
        }
        EntryObject parsedObject = parser.parse(this.rawString);
        return parsedObject;
    }
}

