/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.ss;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import uk.ac.ebi.uniprot.parser.ParseTreeObjectExtractor;
import uk.ac.ebi.uniprot.parser.antlr.SsLineParser;
import uk.ac.ebi.uniprot.parser.antlr.SsLineParserBaseListener;
import uk.ac.ebi.uniprot.parser.impl.ss.SsLineObject;

public class SsLineModelListener
extends SsLineParserBaseListener
implements ParseTreeObjectExtractor<SsLineObject> {
    private SsLineObject object;
    private DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ofPattern("dd-MMM-yyyy")).toFormatter(Locale.ENGLISH);

    @Override
    public void enterSs_ss(SsLineParser.Ss_ssContext ctx) {
        this.object = new SsLineObject();
    }

    @Override
    public void exitInternal_annotation_line(SsLineParser.Internal_annotation_lineContext ctx) {
        SsLineObject.SsLine ssLine = new SsLineObject.SsLine();
        ssLine.topic = ctx.TOPIC().getText();
        ssLine.text = ctx.IA_TEXT().getText();
        this.object.ssIALines.add(ssLine);
    }

    @Override
    public void exitSource_section_line(SsLineParser.Source_section_lineContext ctx) {
        String text = ctx.SOURCE_TEXT().getText();
        this.object.ssSourceLines.add(text);
    }

    @Override
    public void exitEvidence_line(SsLineParser.Evidence_lineContext ctx) {
        SsLineObject.EvLine evLine = new SsLineObject.EvLine();
        evLine.id = ctx.ev_id().getText();
        evLine.date = LocalDate.parse(ctx.EV_DATE().getText(), this.formatter);
        evLine.attr2 = ctx.ev_attr_2() != null ? ctx.ev_attr_2().getText() : "";
        evLine.db = ctx.ev_db().getText();
        int i = evLine.db.indexOf(58);
        if (i >= 0) {
            String db = evLine.db.substring(0, i);
            String attr = evLine.db.substring(i + 1);
            evLine.db = db;
            evLine.attr1 = attr;
        } else {
            evLine.attr1 = ctx.ev_attr_1() != null ? ctx.ev_attr_1().getText() : "";
        }
        this.object.ssEVLines.add(evLine);
    }

    @Override
    public SsLineObject getObject() {
        return this.object;
    }
}

