/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.rl;

import java.util.ArrayList;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Editor;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Thesis;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.UnpublishedObservations;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.impl.rl.RlLineObject;

public class RlLineConverter
implements Converter<RlLineObject, Citation> {
    private DefaultCitationNewFactory factory = DefaultCitationNewFactory.getInstance();

    @Override
    public Citation convert(RlLineObject f) {
        if (f.reference instanceof RlLineObject.JournalArticle) {
            return this.convert((RlLineObject.JournalArticle)f.reference);
        }
        if (f.reference instanceof RlLineObject.Book) {
            return this.convert((RlLineObject.Book)f.reference);
        }
        if (f.reference instanceof RlLineObject.EPub) {
            return this.convert((RlLineObject.EPub)f.reference);
        }
        if (f.reference instanceof RlLineObject.Patent) {
            return this.convert((RlLineObject.Patent)f.reference);
        }
        if (f.reference instanceof RlLineObject.Submission) {
            return this.convert((RlLineObject.Submission)f.reference);
        }
        if (f.reference instanceof RlLineObject.Thesis) {
            return this.convert((RlLineObject.Thesis)f.reference);
        }
        if (f.reference instanceof RlLineObject.Unpublished) {
            return this.convert((RlLineObject.Unpublished)f.reference);
        }
        throw new RuntimeException("Unable to parse RL line");
    }

    @Override
    private Citation convert(RlLineObject.JournalArticle ja) {
        JournalArticle citation = this.factory.buildJournalArticle();
        citation.setJournalName(this.factory.buildJournalName(ja.journal));
        citation.setFirstPage(this.factory.buildPage("" + ja.firstPage));
        citation.setLastPage(this.factory.buildPage("" + ja.lastPage));
        citation.setPublicationDate(this.factory.buildPublicationDate("" + ja.year));
        citation.setVolume(this.factory.buildVolume("" + ja.volume));
        return citation;
    }

    @Override
    private Citation convert(RlLineObject.Book b) {
        Book citation = this.factory.buildBook();
        if (b.pageStart != null) {
            citation.setFirstPage(this.factory.buildPage("" + b.pageStart));
        }
        if (b.pageEnd != null) {
            citation.setLastPage(this.factory.buildPage("" + b.pageEnd));
        }
        citation.setPublicationDate(this.factory.buildPublicationDate("" + b.year));
        if (b.volume != null) {
            citation.setVolume(this.factory.buildVolume("" + b.volume));
        }
        if (b.pageStart == null && b.pageEnd == null && b.pageString != null) {
            citation.setBookName(this.factory.buildBookName(b.title + ", " + b.pageString));
        } else {
            citation.setBookName(this.factory.buildBookName(b.title));
        }
        ArrayList<Editor> editors = new ArrayList<Editor>();
        for (String val : b.editors) {
            editors.add(this.factory.buildEditor(val));
        }
        citation.setEditors(editors);
        if (b.press != null && !b.press.isEmpty()) {
            citation.setPublisher(this.factory.buildPublisher(b.press));
        }
        if (b.place != null && !b.place.isEmpty()) {
            citation.setCity(this.factory.buildCity(b.place));
        }
        return citation;
    }

    @Override
    private Citation convert(RlLineObject.EPub ep) {
        int index;
        String line = ep.title;
        ElectronicArticle citation = this.factory.buildElectronicArticle();
        String pubDate = null;
        if (line.endsWith(")") && (index = line.lastIndexOf(40)) != -1) {
            pubDate = line.substring(index + 1, line.length() - 1);
            line = line.substring(0, index).trim();
            citation.setPublicationDate(this.factory.buildPublicationDate(pubDate));
        }
        if (line.startsWith("Plant Gene Register ")) {
            citation.setJournalName(this.factory.buildJournalName("Plant Gene Register"));
            citation.setLocator(this.factory.buildLocator(line.substring(line.lastIndexOf(32) + 1, line.length())));
        } else if (line.startsWith("Worm Breeder's Gazette")) {
            citation.setJournalName(this.factory.buildJournalName("Worm Breeder's Gazette"));
            citation.setLocator(this.factory.buildLocator(line.substring(line.lastIndexOf(32) + 1, line.length())));
        } else {
            citation.setJournalName(this.factory.buildJournalName(line));
        }
        return citation;
    }

    @Override
    private Citation convert(RlLineObject.Patent patent) {
        Patent citation = this.factory.buildPatent();
        citation.setPatentNumber(this.factory.buildPatentNumber(patent.patentNumber));
        String day = "" + patent.day;
        if (patent.day < 10) {
            day = "0" + patent.day;
        }
        String date = day + "-" + patent.month + "-" + patent.year;
        citation.setPublicationDate(this.factory.buildPublicationDate(date));
        return citation;
    }

    @Override
    private Citation convert(RlLineObject.Submission submission) {
        Submission citation = this.factory.buildSubmission();
        switch (submission.db) {
            case EMBL: {
                citation.setSubmittedToDatabase(SubmissionDatabase.EMBL_GENBANK_DDBJ);
                break;
            }
            case UNIPROTKB: {
                citation.setSubmittedToDatabase(SubmissionDatabase.UNIPROTKB);
                break;
            }
            case PDB: {
                citation.setSubmittedToDatabase(SubmissionDatabase.PDB);
                break;
            }
            case PIR: {
                citation.setSubmittedToDatabase(SubmissionDatabase.PIR);
                break;
            }
            default: {
                throw new RuntimeException("submission db is not supported");
            }
        }
        String date = submission.month + "-" + submission.year;
        citation.setPublicationDate(this.factory.buildPublicationDate(date));
        return citation;
    }

    @Override
    private Citation convert(RlLineObject.Thesis thesis) {
        Thesis citation = this.factory.buildThesis();
        citation.setPublicationDate(this.factory.buildPublicationDate("" + thesis.year));
        citation.setInstitute(this.factory.buildInstitute(thesis.institute));
        if (thesis.country != null) {
            citation.setCountry(this.factory.buildCountry(thesis.country));
        }
        return citation;
    }

    @Override
    private Citation convert(RlLineObject.Unpublished unpub) {
        UnpublishedObservations citation = this.factory.buildUnpublishedObservations();
        citation.setPublicationDate(this.factory.buildPublicationDate(unpub.month + "-" + unpub.year));
        return citation;
    }
}

