/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.parser.impl.gn;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneNameSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.ORFName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.OrderedLocusName;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.parser.Converter;
import uk.ac.ebi.uniprot.parser.impl.EvidenceHelper;
import uk.ac.ebi.uniprot.parser.impl.EvidenceIdCollector;
import uk.ac.ebi.uniprot.parser.impl.gn.GnLineObject;

public class GnLineConverter
extends EvidenceIdCollector
implements Converter<GnLineObject, List<Gene>> {
    @Override
    public List<Gene> convert(GnLineObject f) {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (GnLineObject.GnObject gno : f.gnObjects) {
            Gene gene = DefaultUniProtFactory.getInstance().buildGene();
            for (GnLineObject.GnName gn : gno.names) {
                Map<Object, List<EvidenceId>> evidences = EvidenceHelper.convert(gn.getEvidenceInfo());
                this.addAll(evidences.values());
                switch (gn.type) {
                    case GENAME: {
                        if (gn.names.isEmpty()) break;
                        GeneName geneName = DefaultUniProtFactory.getInstance().buildGeneName();
                        geneName.setValue(gn.names.get(0));
                        EvidenceHelper.setEvidences(geneName, evidences, gn.names.get(0));
                        gene.setGeneName(geneName);
                        break;
                    }
                    case SYNNAME: {
                        ArrayList<GeneNameSynonym> synonyms = new ArrayList<GeneNameSynonym>();
                        for (String string : gn.names) {
                            GeneNameSynonym synonym = DefaultUniProtFactory.getInstance().buildGeneNameSynonym();
                            synonym.setValue(string);
                            EvidenceHelper.setEvidences(synonym, evidences, string);
                            synonyms.add(synonym);
                        }
                        gene.setGeneNameSynonyms(synonyms);
                        break;
                    }
                    case ORFNAME: {
                        ArrayList<ORFName> orfNames = new ArrayList<ORFName>();
                        for (String name2 : gn.names) {
                            ORFName orfname = DefaultUniProtFactory.getInstance().buildORFName();
                            orfname.setValue(name2);
                            EvidenceHelper.setEvidences(orfname, evidences, name2);
                            orfNames.add(orfname);
                        }
                        gene.setORFNames(orfNames);
                        break;
                    }
                    case OLNAME: {
                        ArrayList<OrderedLocusName> arrayList = new ArrayList<OrderedLocusName>();
                        for (String name : gn.names) {
                            OrderedLocusName olname = DefaultUniProtFactory.getInstance().buildOrderedLocusName();
                            olname.setValue(name);
                            EvidenceHelper.setEvidences(olname, evidences, name);
                            arrayList.add(olname);
                        }
                        gene.setOrderedLocusNames(arrayList);
                    }
                }
            }
            genes.add(gene);
        }
        return genes;
    }
}

