/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.impl;

import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.uniprot.dataservice.serializer.EntrySerializer;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EntryConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.SchemaGenerator;
import uk.ac.ebi.uniprot.dataservice.serializer.impl.AvroByteArraySerializer;
import uk.ac.ebi.uniprot.services.data.serializer.model.entry.EntryObject;

public class AvroSerializer
implements EntrySerializer {
    private static final Logger logger = LoggerFactory.getLogger(AvroSerializer.class);
    private final EntryConverter converter;
    private final AvroByteArraySerializer<EntryObject> avro;
    private long decodeCount = 0L;
    private long encodeCount = 0L;
    private long decodeTime = 0L;
    private long encodeTime = 0L;

    @Inject
    public AvroSerializer(EntryConverter converter) {
        this.converter = converter;
        this.avro = AvroByteArraySerializer.instanceOf(EntryObject.class);
    }

    @Override
    public byte[] serialize(UniProtEntry entry) {
        long l = System.nanoTime();
        EntryObject entryObject = this.converter.toAvro(entry);
        byte[] bytes = this.avro.toByteArray(entryObject);
        ++this.encodeCount;
        this.encodeTime += System.nanoTime() - l;
        if (this.encodeCount % 10000L == 0L) {
            logger.trace("{} uniprot entry object is serialized into bytes in {} nano seconds", (Object)this.encodeCount, (Object)this.encodeTime);
        }
        return bytes;
    }

    @Override
    public UniProtEntry deserialize(byte[] bytes) {
        long l = System.nanoTime();
        EntryObject entryObject = this.avro.fromByteArray(bytes, SchemaGenerator.INSTANCE.getWriteSchema());
        UniProtEntry to = this.converter.fromAvro(entryObject);
        ++this.decodeCount;
        this.decodeTime += System.nanoTime() - l;
        if (this.decodeCount % 10000L == 0L) {
            logger.trace("{} uniprot entry object is deserialized from bytes in {} nano seconds", (Object)this.decodeCount, (Object)this.decodeTime);
        }
        return to;
    }

    @Override
    public String deserializeToJSON(byte[] bytes) {
        EntryObject entryObject = this.avro.fromByteArray(bytes, SchemaGenerator.INSTANCE.getWriteSchema());
        String s = this.avro.toJson(entryObject, true, EntryObject.getClassSchema());
        return s;
    }
}

