/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.ref;

import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ref.CitationUpdater;
import uk.ac.ebi.uniprot.services.data.serializer.model.ref.Book;

public class BookUpdater
implements CitationUpdater {
    private static DefaultCitationNewFactory factory = DefaultCitationNewFactory.getInstance();

    @Override
    public Object convertToAvro(Citation ci) {
        if (!(ci instanceof Book)) {
            return new Object();
        }
        Book val = (Book)ci;
        Book.Builder builder = uk.ac.ebi.uniprot.services.data.serializer.model.ref.Book.newBuilder();
        builder.setEditors(val.getEditors().stream().map(s -> s.getValue()).collect(Collectors.toList()));
        builder.setName(val.getBookName().getValue());
        builder.setPlace(val.getCity().getValue());
        builder.setPublisher(val.getPublisher().getValue());
        String page = val.getFirstPage().getValue() + "=" + val.getLastPage().getValue();
        builder.setPage(page);
        builder.setVolume(val.getVolume().getValue());
        return builder.build();
    }

    @Override
    public Citation update(Citation ci, Object obj) {
        if (!(ci instanceof Book)) {
            return ci;
        }
        Book val = (Book)ci;
        uk.ac.ebi.uniprot.services.data.serializer.model.ref.Book data = (uk.ac.ebi.uniprot.services.data.serializer.model.ref.Book)((Object)obj);
        val.setBookName(factory.buildBookName(data.getName().toString()));
        val.setCity(factory.buildCity(data.getPlace().toString()));
        val.setEditors(data.getEditors().stream().map(s -> factory.buildEditor(s.toString())).collect(Collectors.toList()));
        String[] pages = data.getPage().toString().split("=");
        if (pages.length > 0) {
            val.setFirstPage(factory.buildPage(pages[0]));
        }
        if (pages.length > 1) {
            val.setLastPage(factory.buildPage(pages[1]));
        }
        val.setVolume(factory.buildVolume(data.getVolume().toString()));
        val.setPublisher(factory.buildPublisher(data.getPublisher().toString()));
        return val;
    }
}

