/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import joptsimple.internal.Strings;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionType;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.InteractionItem;

public class InteractionConverter
implements Converter<Interaction, InteractionItem> {
    private final CommentFactory factory = DefaultCommentFactory.getInstance();

    @Override
    public InteractionItem toAvro(Interaction interaction) {
        InteractionItem.Builder itemBuilder = InteractionItem.newBuilder();
        itemBuilder.setFirstInteractor(interaction.getFirstInteractor().getValue());
        itemBuilder.setSecondInteractor(interaction.getSecondInteractor().getValue());
        itemBuilder.setExperiments(interaction.getNumberOfExperiments());
        itemBuilder.setGene(interaction.getInteractionGeneName().getValue());
        itemBuilder.setType(interaction.getInteractionType().name());
        itemBuilder.setFirstInteractant(interaction.getFirstInteractant().getValue());
        itemBuilder.setSecondInteractant(interaction.getSecondInteractant().getValue());
        if (!Strings.isNullOrEmpty((String)interaction.getSecondInteractantParent().getValue())) {
            itemBuilder.setSecondInteractantParent(interaction.getSecondInteractantParent().getValue());
        }
        return itemBuilder.build();
    }

    @Override
    public Interaction fromAvro(InteractionItem item) {
        Interaction interaction = this.factory.buildInteraction();
        interaction.setInteractionType(InteractionType.valueOf(item.getType().toString()));
        interaction.setFirstInteractor(this.factory.buildIntActAccession(item.getFirstInteractor().toString()));
        interaction.setSecondInteractor(this.factory.buildIntActAccession(item.getSecondInteractor().toString()));
        interaction.setInteractionGeneName(this.factory.buildInteractionGeneName(item.getGene().toString()));
        interaction.setNumberOfExperiments(item.getExperiments());
        interaction.setFirstInteractant(this.factory.buildInteractorUniProtId(item.getFirstInteractant().toString()));
        interaction.setSecondInteractant(this.factory.buildInteractorUniProtId(item.getSecondInteractant().toString()));
        if (item.getSecondInteractantParent() != null) {
            interaction.setSecondInteractantParent(this.factory.buildInteractorUniProtId(item.getSecondInteractantParent().toString()));
        }
        return interaction;
    }
}

