/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro.comment;

import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Cofactor;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReference;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorReferenceType;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.cc.CofactorItem;

public class CofactorItemConverter
implements Converter<Cofactor, CofactorItem> {
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();
    private final CommentFactory factory = DefaultCommentFactory.getInstance();

    @Override
    public CofactorItem toAvro(Cofactor cf) {
        CofactorItem.Builder itemBuilder = CofactorItem.newBuilder();
        itemBuilder.setName(cf.getName());
        itemBuilder.setDbid(cf.getCofactorReference().getReferenceId());
        itemBuilder.setDbtype(cf.getCofactorReference().getCofactorReferenceType().toDisplayName());
        itemBuilder.setEvidence(this.evidenceConverter.toAvro(cf.getEvidenceIds()));
        return itemBuilder.build();
    }

    @Override
    public Cofactor fromAvro(CofactorItem item) {
        Cofactor cf = this.factory.buildCofactor();
        cf.setName(item.getName().toString());
        CofactorReference ref = this.factory.buildCofactorReference();
        ref.setReferenceId(item.getDbid().toString());
        ref.setCofactorReferenceType(CofactorReferenceType.typeOf(item.getDbtype().toString()));
        cf.setCofactorReference(ref);
        if (item.getEvidence() != null && !item.getEvidence().isEmpty()) {
            cf.setEvidenceIds(this.evidenceConverter.fromAvro(item.getEvidence()));
        }
        return cf;
    }
}

