/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxon;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.interfaces.uniprot.OrganismHost;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.ConverterHelper;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.OrganelleConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.OrganismHostConverter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.OrganismNameConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ev.EvidencedString;
import uk.ac.ebi.uniprot.services.data.serializer.model.og.Host;
import uk.ac.ebi.uniprot.services.data.serializer.model.og.Organism;

public class OrganismConverter
implements Converter<UniProtOrganismInfo, Organism> {
    private static DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
    private static EvidenceConverter evidenceConverter = new EvidenceConverter();
    private final TaxonIdConverter taxIdConverter = new TaxonIdConverter();
    private final OrganismHostConverter organismHostConverter = new OrganismHostConverter();
    private final OrganelleConverter organelleConverter = new OrganelleConverter();
    private final OrganismNameConverter organismNameConverter = new OrganismNameConverter();

    @Override
    public Organism toAvro(UniProtOrganismInfo organismInfo) {
        Organism.Builder builder = Organism.newBuilder();
        builder.setLineage(organismInfo.getTaxonomy().stream().map(tax -> tax.getValue()).collect(Collectors.toList()));
        builder.setNcbiTaxId((Object)this.taxIdConverter.toAvro(organismInfo.getNcbiTaxonomyIds().get(0)));
        builder.setHosts(organismInfo.getOrganismHosts().stream().map(h -> this.organismHostConverter.toAvro((OrganismHost)h)).collect(Collectors.toList()));
        builder.setOrganelles(organismInfo.getOrganelles().stream().map(og -> this.organelleConverter.toAvro((Organelle)og)).collect(Collectors.toList()));
        builder.setNames(this.organismNameConverter.toAvro(organismInfo.getOrganism()));
        return builder.build();
    }

    @Override
    public UniProtOrganismInfo fromAvro(Organism avroOrganism) {
        List<NcbiTaxon> taxonomy = avroOrganism.getLineage().stream().map(tax -> factory.buildNcbiTaxon(tax.toString())).collect(Collectors.toList());
        ArrayList<NcbiTaxonomyId> ncbiTaxonomyIds = new ArrayList<NcbiTaxonomyId>();
        ncbiTaxonomyIds.add(this.taxIdConverter.fromAvro((EvidencedString)((Object)avroOrganism.getNcbiTaxId())));
        List<OrganismHost> organismHosts = avroOrganism.getHosts().stream().map(h -> this.organismHostConverter.fromAvro((Host)((Object)h))).collect(Collectors.toList());
        List<Organelle> organelles = avroOrganism.getOrganelles().stream().map(og -> this.organelleConverter.fromAvro((uk.ac.ebi.uniprot.services.data.serializer.model.og.Organelle)((Object)og))).collect(Collectors.toList());
        return new UniProtOrganismInfo(this.organismNameConverter.fromAvro(avroOrganism.getNames()), taxonomy, ncbiTaxonomyIds, organismHosts, organelles);
    }

    private static class TaxonIdConverter
    implements Converter<NcbiTaxonomyId, EvidencedString> {
        private TaxonIdConverter() {
        }

        @Override
        public EvidencedString toAvro(NcbiTaxonomyId u) {
            return ConverterHelper.convert(u.getValue(), u.getEvidenceIds());
        }

        @Override
        public NcbiTaxonomyId fromAvro(EvidencedString a) {
            NcbiTaxonomyId taxId = factory.buildNcbiTaxonomyId(a.getKey().toString());
            taxId.setEvidenceIds(evidenceConverter.fromAvro(a.getEvidence()));
            return taxId;
        }
    }

    public static class UniProtOrganismInfo {
        private final uk.ac.ebi.kraken.interfaces.uniprot.Organism organism;
        private final List<NcbiTaxon> taxonomy;
        private final List<NcbiTaxonomyId> ncbiTaxonomyIds;
        private final List<OrganismHost> organismHosts;
        private final List<Organelle> organelles;

        public UniProtOrganismInfo(uk.ac.ebi.kraken.interfaces.uniprot.Organism organism, List<NcbiTaxon> taxonomy, List<NcbiTaxonomyId> ncbiTaxonomyIds, List<OrganismHost> organismHosts, List<Organelle> organelles) {
            this.organism = organism;
            this.taxonomy = taxonomy;
            this.ncbiTaxonomyIds = ncbiTaxonomyIds;
            this.organismHosts = organismHosts;
            this.organelles = organelles;
        }

        public uk.ac.ebi.kraken.interfaces.uniprot.Organism getOrganism() {
            return this.organism;
        }

        public List<NcbiTaxon> getTaxonomy() {
            return this.taxonomy;
        }

        public List<NcbiTaxonomyId> getNcbiTaxonomyIds() {
            return this.ncbiTaxonomyIds;
        }

        public List<OrganismHost> getOrganismHosts() {
            return this.organismHosts;
        }

        public List<Organelle> getOrganelles() {
            return this.organelles;
        }
    }
}

