/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.EntryAudit;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinExistence;
import uk.ac.ebi.kraken.interfaces.uniprot.SecondaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntryType;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.SimpleDateConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.ac.EntryInfo;

public class EntryInfoConverter
implements Converter<UniProtEntryInfo, EntryInfo> {
    private static final DefaultUniProtFactory UNIPROT_FACTORY = DefaultUniProtFactory.getInstance();
    private final SimpleDateConverter dateConverter = new SimpleDateConverter();

    @Override
    public EntryInfo toAvro(UniProtEntryInfo entryInfo) {
        EntryInfo.Builder builder = EntryInfo.newBuilder();
        builder.setModified(this.dateConverter.toAvro(entryInfo.getEntryAudit().getLastAnnotationUpdateDate()));
        builder.setSequenceUpdated(this.dateConverter.toAvro(entryInfo.getEntryAudit().getLastSequenceUpdateDate()));
        builder.setCreated(this.dateConverter.toAvro(entryInfo.getEntryAudit().getFirstPublicDate()));
        builder.setVersion(entryInfo.getEntryAudit().getEntryVersion());
        builder.setSequenceVersion(entryInfo.getEntryAudit().getSequenceVersion());
        builder.setName(entryInfo.getUniProtId().getValue());
        builder.setAccession(entryInfo.getPrimaryUniProtAccession().getValue());
        builder.setReviewed(entryInfo.getType() == UniProtEntryType.SWISSPROT);
        builder.setSecondaryAccession(entryInfo.getSecondaryUniProtAccessions().stream().map(sa -> sa.getValue()).collect(Collectors.toList()));
        builder.setProteinExistence(entryInfo.getProteinExistence().getValue());
        return builder.build();
    }

    @Override
    public UniProtEntryInfo fromAvro(EntryInfo avroEntryInfo) {
        EntryAudit entryAudit = UNIPROT_FACTORY.buildEntryAudit();
        entryAudit.setFirstPublicDate(this.dateConverter.fromAvro(avroEntryInfo.getCreated().toString()));
        entryAudit.setLastAnnotationUpdateDate(this.dateConverter.fromAvro(avroEntryInfo.getModified().toString()));
        entryAudit.setLastSequenceUpdateDate(this.dateConverter.fromAvro(avroEntryInfo.getSequenceUpdated().toString()));
        entryAudit.setEntryVersion(avroEntryInfo.getVersion());
        entryAudit.setSequenceVersion(avroEntryInfo.getSequenceVersion());
        UniProtId uniprotId = UNIPROT_FACTORY.buildUniProtId(avroEntryInfo.getName().toString());
        PrimaryUniProtAccession accession = UNIPROT_FACTORY.buildPrimaryUniProtAccession(avroEntryInfo.getAccession().toString());
        UniProtEntryType type = UniProtEntryType.TREMBL;
        if (avroEntryInfo.getReviewed().booleanValue()) {
            type = UniProtEntryType.SWISSPROT;
        }
        List<SecondaryUniProtAccession> secondaryAccessions = avroEntryInfo.getSecondaryAccession().stream().map(sa -> UNIPROT_FACTORY.buildSecondaryUniProtAccession(sa.toString())).collect(Collectors.toList());
        ProteinExistence proteinExistence = ProteinExistence.typeOf(avroEntryInfo.getProteinExistence().toString());
        return new UniProtEntryInfo(type, accession, uniprotId, secondaryAccessions, proteinExistence, entryAudit);
    }

    public static class UniProtEntryInfo {
        private final UniProtEntryType type;
        private final PrimaryUniProtAccession primaryUniProtAccession;
        private final UniProtId uniprotId;
        private final List<SecondaryUniProtAccession> secondaryUniProtAccession;
        private final ProteinExistence proteinExistence;
        private final EntryAudit entryAudit;

        public UniProtEntryInfo(UniProtEntryType entryType, PrimaryUniProtAccession accession, UniProtId uniprotId, List<SecondaryUniProtAccession> secondaryAccessions, ProteinExistence proteinExistence, EntryAudit entryAudit) {
            this.type = entryType;
            this.primaryUniProtAccession = accession;
            this.uniprotId = uniprotId;
            this.secondaryUniProtAccession = secondaryAccessions;
            this.proteinExistence = proteinExistence;
            this.entryAudit = entryAudit;
        }

        public UniProtEntryType getType() {
            return this.type;
        }

        public PrimaryUniProtAccession getPrimaryUniProtAccession() {
            return this.primaryUniProtAccession;
        }

        public UniProtId getUniProtId() {
            return this.uniprotId;
        }

        public List<SecondaryUniProtAccession> getSecondaryUniProtAccessions() {
            return this.secondaryUniProtAccession;
        }

        public ProteinExistence getProteinExistence() {
            return this.proteinExistence;
        }

        public EntryAudit getEntryAudit() {
            return this.entryAudit;
        }
    }
}

