/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.serializer.avro;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.Converter;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.EvidenceConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.dr.Xref;

public class DBCrossReferenceConverter
implements Converter<DatabaseCrossReference, Xref> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBCrossReferenceConverter.class);
    private final DefaultXRefFactory factory = DefaultXRefFactory.getInstance();
    private final EvidenceConverter evidenceConverter = new EvidenceConverter();

    @Override
    public Xref toAvro(DatabaseCrossReference u) {
        Xref.Builder builder = Xref.newBuilder();
        builder.setType(u.getDatabase().getName());
        if (u.getIsoformId() != null && !u.getIsoformId().getValue().isEmpty()) {
            builder.setIsoForm(u.getIsoformId().getValue());
        }
        builder.setId(u.getPrimaryId().getValue());
        builder.setDescription(u.getDescription().getValue());
        if (u.hasThird()) {
            builder.setThird(u.getThird().getValue());
        }
        if (u.hasFourth()) {
            builder.setFourth(u.getFourth().getValue());
        }
        if (u.getEvidenceIds() != null && !u.getEvidenceIds().isEmpty()) {
            builder.setEvidences(this.evidenceConverter.toAvro(u.getEvidenceIds()));
        }
        return builder.build();
    }

    @Override
    public DatabaseCrossReference fromAvro(Xref a) {
        DatabaseType type = DatabaseType.getDatabaseType(a.getType().toString());
        if (type == DatabaseType.UNKNOWN) {
            LOGGER.error("DatabaseType: " + a.getType() + " is unknown.");
            return null;
        }
        DatabaseCrossReference dbXref = this.factory.buildDatabaseCrossReference(type);
        if (a.getIsoForm() != null) {
            dbXref.setIsoformId(DefaultUniProtFactory.getInstance().buildUniProtIsoformId(a.getIsoForm().toString()));
        }
        dbXref.setPrimaryId(this.factory.buildXDBAttribute(a.getId().toString()));
        dbXref.setDescription(this.factory.buildXDBAttribute(a.getDescription().toString()));
        if (dbXref.hasThird() && a.getThird() != null) {
            dbXref.setThird(this.factory.buildXDBAttribute(a.getThird().toString()));
        }
        if (dbXref.hasFourth() && a.getFourth() != null) {
            dbXref.setFourth(this.factory.buildXDBAttribute(a.getFourth().toString()));
        }
        if (a.getEvidences() != null && !a.getEvidences().isEmpty()) {
            dbXref.setEvidenceIds(this.evidenceConverter.fromAvro(a.getEvidences()));
        }
        return dbXref;
    }
}

