/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.domain.info.impl;

import java.util.Map;
import uk.ac.ebi.uniprot.dataservice.domain.info.InfoObjectConverter;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObject;
import uk.ac.ebi.uniprot.dataservice.domain.info.ServiceInfoObject;
import uk.ac.ebi.uniprot.dataservice.domain.info.impl.ServiceInfoObjectImpl;
import uk.ac.ebi.uniprot.dataservice.domain.info.impl.UniParcInfoObjectImpl;
import uk.ac.ebi.uniprot.dataservice.domain.info.impl.UniProtInfoObjectImpl;
import uk.ac.ebi.uniprot.dataservice.domain.info.impl.UniRefInfoObjectImpl;

public class InfoObjectConverterImpl
implements InfoObjectConverter {
    @Override
    public ServiceInfoObject convert(RawInfoObject rawinfo) {
        UniProtInfoObjectImpl uniProtInfoObject = this.getUniProtInfoObject(rawinfo);
        UniParcInfoObjectImpl uniParcInfoObject = this.getUniParcInfoObject(rawinfo);
        UniRefInfoObjectImpl uniRefInfoObject = this.getUniRefInfoObject(rawinfo);
        return new ServiceInfoObjectImpl(uniParcInfoObject, uniRefInfoObject, uniProtInfoObject);
    }

    private UniRefInfoObjectImpl getUniRefInfoObject(RawInfoObject rawinfo) {
        Map<RawInfoObject.InfoKey, String> infosOfType3 = rawinfo.getInfosOfType(RawInfoObject.InfoType.uniref_index);
        UniRefInfoObjectImpl uniRefInfoObject = new UniRefInfoObjectImpl();
        uniRefInfoObject.setUniref50(this.parseLong(infosOfType3, RawInfoObject.InfoKey.uniref50_count));
        uniRefInfoObject.setUniref90(this.parseLong(infosOfType3, RawInfoObject.InfoKey.uniref90_count));
        uniRefInfoObject.setUniref100(this.parseLong(infosOfType3, RawInfoObject.InfoKey.uniref100_count));
        return uniRefInfoObject;
    }

    private UniParcInfoObjectImpl getUniParcInfoObject(RawInfoObject rawinfo) {
        Map<RawInfoObject.InfoKey, String> infosOfType2 = rawinfo.getInfosOfType(RawInfoObject.InfoType.uniparc_index);
        UniParcInfoObjectImpl uniParcInfoObject = new UniParcInfoObjectImpl();
        uniParcInfoObject.setUPIs(this.parseLong(infosOfType2, RawInfoObject.InfoKey.uniparc_upi_count));
        uniParcInfoObject.setXrefs(this.parseLong(infosOfType2, RawInfoObject.InfoKey.uniparc_xref_count));
        return uniParcInfoObject;
    }

    private UniProtInfoObjectImpl getUniProtInfoObject(RawInfoObject rawinfo) {
        Map<RawInfoObject.InfoKey, String> infosOfType = rawinfo.getInfosOfType(RawInfoObject.InfoType.uniprot_index);
        UniProtInfoObjectImpl uniProtInfoObject = new UniProtInfoObjectImpl();
        uniProtInfoObject.setReleaseNumber(infosOfType.get((Object)RawInfoObject.InfoKey.release_number));
        uniProtInfoObject.setSwissProtEntries(this.parseLong(infosOfType, RawInfoObject.InfoKey.swissprot_count));
        uniProtInfoObject.setTremblEntries(this.parseLong(infosOfType, RawInfoObject.InfoKey.trembl_count));
        uniProtInfoObject.setIsoformEntries(this.parseLong(infosOfType, RawInfoObject.InfoKey.isoform_count));
        return uniProtInfoObject;
    }

    private long parseLong(Map<RawInfoObject.InfoKey, String> map, RawInfoObject.InfoKey key) {
        String orDefault = map.getOrDefault((Object)key, "0");
        try {
            return Long.parseLong(orDefault);
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

