/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniparc.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcId;
import uk.ac.ebi.uniprot.dataservice.client.impl.ResponseAdaptor;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcComponent;
import uk.ac.ebi.uniprot.dataservice.serializer.avro.uniparc.UniParcConverter;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniparc.AvroUniParc;

class JapiUniParcResponseAdapter {
    static final JapiUniParcEntryAdapter entryAdapter = new JapiUniParcEntryAdapter();
    static final JapiUniParcSequenceAdapter sequenceAdapter = new JapiUniParcSequenceAdapter();
    private static final UniParcConverter avroXmlConverter = new UniParcConverter();

    JapiUniParcResponseAdapter() {
    }

    static class UniParcComponentImpl<T>
    implements UniParcComponent<T> {
        private final UniParcId uniParcId;
        private final List<T> components;

        UniParcComponentImpl(UniParcId uniParcId, List<T> components) {
            Preconditions.checkArgument((uniParcId != null ? 1 : 0) != 0, (Object)"UniParc identifier can not be null");
            this.uniParcId = uniParcId;
            this.components = new ArrayList<T>(components);
        }

        @Override
        public UniParcId getEntryIdentifier() {
            return this.uniParcId;
        }

        @Override
        public List<T> getComponents() {
            return this.components;
        }
    }

    static class JapiUniParcSequenceAdapter
    implements ResponseAdaptor<UniParcComponent<Sequence>, AvroUniParc> {
        JapiUniParcSequenceAdapter() {
        }

        @Override
        public UniParcComponent<Sequence> adapt(AvroUniParc entry) {
            UniParcEntry uniParcEntry = avroXmlConverter.fromAvro(entry);
            return new UniParcComponentImpl<Sequence>(uniParcEntry.getUniParcId(), Collections.singletonList(uniParcEntry.getSequence()));
        }
    }

    static class JapiUniParcEntryAdapter
    implements ResponseAdaptor<UniParcEntry, AvroUniParc> {
        JapiUniParcEntryAdapter() {
        }

        @Override
        public UniParcEntry adapt(AvroUniParc entry) {
            return avroXmlConverter.fromAvro(entry);
        }
    }
}

