/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.serializer.impl.AvroByteArraySerializer;
import uk.ac.ebi.uniprot.dataservice.voldemort.VoldemortClient;

public class EntryStoreResponse<D, T>
implements Response<D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntryStoreResponse.class);
    private final QueryResponse response;
    private final Class<D> clazz;
    private final DocumentObjectBinder binder;
    private final AvroByteArraySerializer<T> entrySerializer;
    private final VoldemortClient<T> voldemortClient;
    private final String avroFieldName;
    private final String documentId;

    EntryStoreResponse(VoldemortClient<T> voldemortClient, String avroFieldName, String documentId, QueryResponse response, Class<D> clazz, AvroByteArraySerializer<T> entrySerializer) {
        this.response = response;
        this.clazz = clazz;
        this.binder = new DocumentObjectBinder();
        this.voldemortClient = voldemortClient;
        this.avroFieldName = avroFieldName;
        this.documentId = documentId;
        this.entrySerializer = entrySerializer;
    }

    @Override
    public long getHitCount() {
        return this.response.getResults().getNumFound();
    }

    @Override
    public int getResultPageSize() {
        SolrDocumentList results = this.response.getResults();
        return results.size();
    }

    @Override
    public long getResultSetStart() {
        return this.response.getResults().getStart();
    }

    @Override
    public List<D> getResults() {
        SolrDocumentList results = this.response.getResults();
        ArrayList<String> accessions = new ArrayList<String>();
        for (SolrDocument solr : results) {
            accessions.add(solr.get((Object)this.documentId).toString());
        }
        ArrayList<Object> documents = new ArrayList<Object>();
        Map entryMap = this.voldemortClient.getEntryMap(accessions);
        for (SolrDocument result : results) {
            String acc = result.getFieldValue(this.documentId).toString();
            if (entryMap.containsKey(acc)) {
                byte[] bytes = this.entrySerializer.toByteArray(entryMap.get(acc));
                result.put(this.avroFieldName, (Object)bytes);
                documents.add(this.binder.getBean(this.clazz, result));
                continue;
            }
            IllegalStateException ise = new IllegalStateException("Entry store does not contain accession.");
            LOGGER.error("Could not get results", (Throwable)ise);
            throw ise;
        }
        return documents;
    }

    @Override
    public String getCursorMark() {
        return this.response.getNextCursorMark();
    }
}

