/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicRequest;
import uk.ac.ebi.uniprot.dataservice.query.Query;

public class DefaultRequestImpl
implements BasicRequest {
    public static final String QUERY_FIELD = "q";
    public static final String SORT_FIELD = "sort";
    public static final String SORT_DESC = "desc";
    public static final String SORT_ASC = "asc";
    public static final String RETURN_FIELD = "fl";
    public static final String OFFSET_ROW_FIELD = "start";
    public static final String ROWS_TO_RETURN_FIELD = "rows";
    public static final String SORT_DELIMITER = ", ";
    public static final String SORT_DEFAULT_FIELD = "score";
    public static final String CURSOR_MARK_FIELD = "cursorMark";
    private Enum[] filteredFields;
    private Enum sortField;
    private boolean desc;
    private Query condition;
    private long start;
    private int number;
    private String primaryFieldName;
    private String cursorMark = "*";

    @Override
    public long getResultOffset() {
        return this.start;
    }

    @Override
    public void setResultOffset(long start) {
        this.start = start;
        this.cursorMark = null;
    }

    @Override
    public String getCursorMark() {
        return this.cursorMark;
    }

    @Override
    public void setCursorMark(String cursorMark) {
        this.cursorMark = cursorMark;
    }

    @Override
    public int getResultCardinality() {
        return this.number;
    }

    @Override
    public void setResultCardinality(int number) {
        this.number = number;
    }

    @Override
    public Query getQuery() {
        return this.condition;
    }

    @Override
    public void setQuery(Query query) {
        this.condition = query;
    }

    @Override
    public DefaultRequestImpl pageRequest(long start) {
        DefaultRequestImpl duplicate = new DefaultRequestImpl();
        this.copyTo(duplicate);
        duplicate.start = start;
        return duplicate;
    }

    @Override
    public DefaultRequestImpl pageRequest(String cursorMark) {
        DefaultRequestImpl duplicate = new DefaultRequestImpl();
        this.copyTo(duplicate);
        duplicate.cursorMark = cursorMark;
        return duplicate;
    }

    @Override
    public void setFields(Enum ... fields) {
        this.filteredFields = fields;
    }

    @Override
    public void setSort(Enum field, boolean desc) {
        this.sortField = field;
        this.desc = desc;
    }

    @Override
    public void setPrimaryFieldName(String name) {
        this.primaryFieldName = name;
    }

    private String sortFieldToString(String field, boolean desc) {
        return field + " " + (desc ? SORT_DESC : SORT_ASC);
    }

    private String buildSortString() {
        if (this.cursorMark != null) {
            String idSort = this.sortFieldToString(this.primaryFieldName, true);
            String sortString = this.sortFieldToString(this.sortField != null ? this.sortField.name() : SORT_DEFAULT_FIELD, this.sortField != null ? this.desc : true);
            return sortString + SORT_DELIMITER + idSort;
        }
        if (this.sortField != null) {
            return this.sortFieldToString(this.sortField.name(), this.desc);
        }
        return null;
    }

    public void copyTo(BasicRequest req) {
        req.setPrimaryFieldName(this.primaryFieldName);
        req.setFields(this.filteredFields);
        req.setSort(this.sortField, this.desc);
        req.setQuery(this.condition);
        req.setResultOffset(this.start);
        req.setResultCardinality(this.number);
    }

    @Override
    public Map<String, String> buildQueryMap() {
        return this.buildQueryMap(this.condition, this.filteredFields, this.sortField, this.desc, this.start, this.number);
    }

    private Map<String, String> buildQueryMap(Query condition, Enum[] fields, Enum sortField, boolean desc, long start, long number) {
        if (condition == null) {
            throw new IllegalArgumentException("Query condition cannot be null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String string = condition.getQueryString();
        map.put(QUERY_FIELD, string);
        String sortString = this.buildSortString();
        if (sortString != null) {
            map.put(SORT_FIELD, sortString);
        }
        if (fields != null && fields.length >= 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(fields[0]);
            for (int i = 1; i < fields.length; ++i) {
                stringBuilder.append(",").append(fields[i]);
            }
            map.put(RETURN_FIELD, stringBuilder.toString());
        } else {
            map.put(RETURN_FIELD, "*");
        }
        if (start > 0L) {
            map.put(OFFSET_ROW_FIELD, Long.toString(start));
        }
        if (number > 0L) {
            map.put(ROWS_TO_RETURN_FIELD, Long.toString(number));
        }
        if (this.cursorMark != null) {
            map.put(CURSOR_MARK_FIELD, this.cursorMark);
        }
        return map;
    }

    @Override
    public String convertFieldsToString() {
        return "filteredFields=" + (this.filteredFields == null ? "null" : Arrays.toString(this.filteredFields)) + ", sortField=" + this.sortField + ", desc=" + this.desc + ", condition=" + this.condition + ", cursorMark=" + this.cursorMark + ", start=" + this.start + ", number=" + this.number;
    }

    public String toString() {
        return "RequestImpl{" + this.convertFieldsToString() + '}';
    }
}

