/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.ClientConfigurator;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;

class ClientConfiguratorImpl
implements ClientConfigurator {
    public static final String CLIENT_PROPERTIES_FILE = "client.properties";
    public static final String DEFAULT_CONFIG_PROPERTIES_URI = "/config.properties";
    private static final Logger logger = LoggerFactory.getLogger(ClientConfiguratorImpl.class);
    @Parameter(names={"-base"}, description="Base Service URL, other URL service will be default to /uniref, /uniparc and /uniprot after this base URL")
    private String baseServiceURL;
    @Parameter(names={"-uniref"}, description="UniRef Service URL")
    private String unirefServiceURL;
    @Parameter(names={"-uniparc"}, description="UniParc Service URL")
    private String uniparcServiceURL;
    @Parameter(names={"-uniprot"}, description="UniProt Service URL")
    private String uniprotServiceURL;
    @Parameter(names={"-info"}, description="Info Service URL")
    private String infoServiceURL;
    @Parameter(names={"-log"}, description="the log level for the JAP client")
    private String logLevel = null;
    @UserNotSettable
    private int uniprotComponentPageSize = 100;
    @UserNotSettable
    private int uniprotEntryPageSize = 50;
    private HttpRequestConfig httpConfig = new HttpRequestConfig();

    private static boolean isUserSettable(String propertyName) {
        try {
            Field declaredField = ClientConfiguratorImpl.class.getDeclaredField(propertyName);
            if (declaredField != null) {
                UserNotSettable annotation = declaredField.getAnnotation(UserNotSettable.class);
                return annotation == null;
            }
            return false;
        }
        catch (NoSuchFieldException e) {
            return true;
        }
    }

    public HttpRequestConfig getHttpConfig() {
        return this.httpConfig;
    }

    @Override
    public String getUniRefServiceURL() {
        if (this.unirefServiceURL != null) {
            return this.unirefServiceURL;
        }
        return this.baseServiceURL + "/uniref/japi";
    }

    @Override
    public String getUniParcServiceURL() {
        if (this.uniparcServiceURL != null) {
            return this.uniparcServiceURL;
        }
        return this.baseServiceURL + "/uniparc/japi";
    }

    public String getInfoServiceURL() {
        if (this.infoServiceURL != null) {
            return this.infoServiceURL;
        }
        return this.baseServiceURL + "/info";
    }

    @Override
    public String getUniProtServiceURL() {
        if (this.uniprotServiceURL != null) {
            return this.uniprotServiceURL;
        }
        return this.baseServiceURL + "/proteins/japi";
    }

    @Override
    public int getUniProtComponentPageSize() {
        return this.uniprotComponentPageSize;
    }

    @Override
    public int getUniProtEntryPageSize() {
        return this.uniprotEntryPageSize;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    public void setBaseURL(String baseURL) {
        this.baseServiceURL = baseURL != null && baseURL.endsWith("/") ? this.baseServiceURL.substring(0, this.baseServiceURL.length() - 1) : baseURL;
    }

    public ClientConfiguratorImpl() {
        this.loadDefault(() -> this.getClass().getResourceAsStream(DEFAULT_CONFIG_PROPERTIES_URI));
        this.overrideWithDefault(() -> {
            try {
                return new FileInputStream(CLIENT_PROPERTIES_FILE);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        });
    }

    ClientConfiguratorImpl(Supplier<InputStream> defaultInput, Supplier<InputStream> overrideInput) {
        if (defaultInput != null) {
            this.loadDefault(defaultInput);
        }
        if (overrideInput != null) {
            this.overrideWithDefault(overrideInput);
        }
    }

    public void loadFromCommandLine(String[] args) {
        new JCommander((Object)this, args);
        this.setBaseURL(this.baseServiceURL);
    }

    public void setUnirefServiceURL(String unirefServiceURL) {
        this.unirefServiceURL = unirefServiceURL;
    }

    public void setUniparcServiceURL(String uniparcServiceURL) {
        this.uniparcServiceURL = uniparcServiceURL;
    }

    public void setUniprotServiceURL(String uniprotServiceURL) {
        this.uniprotServiceURL = uniprotServiceURL;
    }

    public void setInfoServiceURL(String infoServiceUrl) {
        this.infoServiceURL = infoServiceUrl;
    }

    private void loadProperties(Map<Object, Object> p) {
        if (p.get("baseServiceURL") != null) {
            String url = (String)p.get("baseServiceURL");
            this.setBaseURL(url);
        }
        if (p.get("unirefServiceURL") != null) {
            this.unirefServiceURL = (String)p.get("unirefServiceURL");
        }
        if (p.get("uniparcServiceURL") != null) {
            this.uniparcServiceURL = (String)p.get("uniparcServiceURL");
        }
        if (p.get("uniprotServiceURL") != null) {
            this.uniprotServiceURL = (String)p.get("uniprotServiceURL");
        }
        if (p.get("infoServiceURL") != null) {
            this.infoServiceURL = (String)p.get("infoServiceURL");
        }
        if (p.get("log") != null) {
            this.logLevel = (String)p.get("log");
        }
        this.httpConfig.loadDefault((Properties)p);
    }

    private void loadDefault(Supplier<InputStream> fis) {
        try (InputStream inputStream = fis.get();){
            if (inputStream != null) {
                Properties p = new Properties();
                p.load(inputStream);
                this.loadProperties(p);
            }
        }
        catch (IOException e) {
            logger.warn("Could not load the configuration file config.properties, please check the configuration file format.", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Could not load the configuration file config.properties, please check the configuration file format.", (Throwable)e);
        }
    }

    public void overrideWith(Map<String, String> clientConfigurator) {
        Properties properties = new Properties();
        properties.putAll(clientConfigurator);
        this.loadProperties(properties);
    }

    private void overrideWithDefault(Supplier<InputStream> fis) {
        try (InputStream inputStream = fis.get();){
            Properties user_properties = new Properties();
            if (inputStream != null) {
                user_properties.load(inputStream);
                Properties properties = new Properties();
                user_properties.keySet().stream().filter(k -> k instanceof String && ClientConfiguratorImpl.isUserSettable((String)k)).forEach(k -> properties.put(k, user_properties.get(k)));
                this.loadProperties(properties);
            }
        }
        catch (IOException e) {
            logger.warn("error while loading user's configuration");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface UserNotSettable {
    }
}

