/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.examples;

import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxon;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocation;
import uk.ac.ebi.uniprot.dataservice.client.Client;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.ServiceFactory;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtData;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtService;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtServiceInfo;
import uk.ac.ebi.uniprot.dataservice.query.Query;

public final class UniProtRetrievalExamples {
    private static final Logger logger = LoggerFactory.getLogger(UniProtRetrievalExamples.class);

    public static void main(String[] args) {
        LocalTime start = LocalTime.now();
        UniProtRetrievalExamples.driveExamples();
        LocalTime end = LocalTime.now();
        Duration duration = Duration.between(start, end);
        System.out.println("Duration=" + duration.getSeconds() + " seconds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void driveExamples2() {
        ServiceFactory serviceFactoryInstance = Client.getServiceFactoryInstance();
        UniProtService uniProtService = serviceFactoryInstance.getUniProtQueryService();
        try {
            uniProtService.start();
            Query query = UniProtQueryBuilder.comments(CommentType.ALTERNATIVE_PRODUCTS, "P13055-2");
            UniProtRetrievalExamples.accessMultiFullUniProtEntry(uniProtService, query);
            UniProtServiceInfo info = uniProtService.getServiceInfo();
            System.out.println(info.getReleaseNumber() + "\t" + info.getNumberOfTrEmblEntry());
        }
        catch (Exception e) {
            logger.error("drive example2", (Throwable)e);
        }
        finally {
            uniProtService.stop();
            System.out.println("service now stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void driveExamples() {
        ServiceFactory serviceFactoryInstance = Client.getServiceFactoryInstance();
        UniProtService uniProtService = serviceFactoryInstance.getUniProtQueryService();
        try {
            uniProtService.start();
            String accession = "P10415";
            UniProtRetrievalExamples.accessSingleFullUniProtEntry(uniProtService, accession);
            Query query = UniProtQueryBuilder.accession(accession);
            UniProtRetrievalExamples.accessMultiFullUniProtEntry(uniProtService, query);
            UniProtRetrievalExamples.accessCommentsOnly(uniProtService, query);
            UniProtRetrievalExamples.accessFeaturesOnly(uniProtService, query);
            UniProtRetrievalExamples.accessProteinNamesOnly(uniProtService, query);
            UniProtRetrievalExamples.accessECsOnly(uniProtService, query);
            UniProtRetrievalExamples.accessGenesOnly(uniProtService, query);
            UniProtRetrievalExamples.accessXrefsOnly(uniProtService, query);
            UniProtRetrievalExamples.accessResults(uniProtService, query);
            UniProtRetrievalExamples.showResultHits(uniProtService);
        }
        catch (Exception e) {
            logger.error("drive examples", (Throwable)e);
        }
        finally {
            uniProtService.stop();
            System.out.println("service now stopped.");
        }
    }

    public static void accessXrefsOnly(UniProtService uniProtService, Query query) throws ServiceException {
        UniProtRetrievalExamples.printExampleHeader("xrefs");
        QueryResult<UniProtComponent<DatabaseCrossReference>> xrefComponents = uniProtService.getXrefs(query);
        while (xrefComponents.hasNext()) {
            UniProtComponent xrefComponent = (UniProtComponent)xrefComponents.next();
            if (xrefComponent.getComponent().isEmpty()) continue;
            System.out.println("accession: " + xrefComponent.getAccession().getValue());
            for (DatabaseCrossReference dbx : xrefComponent.getComponent()) {
                StringBuilder dbxResultSB = new StringBuilder();
                dbxResultSB.append((Object)dbx.getDatabase()).append(", ").append(dbx.getPrimaryId()).append(", ").append(dbx.getDescription());
                if (dbx.hasThird()) {
                    dbxResultSB.append(", ").append(dbx.getThird());
                }
                if (dbx.hasFourth()) {
                    dbxResultSB.append(", ").append(dbx.getFourth());
                }
                System.out.println("  " + dbxResultSB);
            }
        }
    }

    public static void accessGenesOnly(UniProtService uniProtService, Query query) throws ServiceException {
        UniProtRetrievalExamples.printExampleHeader("genes");
        QueryResult<UniProtComponent<Gene>> geneComponents = uniProtService.getGenes(query);
        while (geneComponents.hasNext()) {
            UniProtComponent geneComponent = (UniProtComponent)geneComponents.next();
            if (geneComponent.getComponent().isEmpty()) continue;
            System.out.println("accession: " + geneComponent.getAccession().getValue());
            for (Gene gene : geneComponent.getComponent()) {
                System.out.println("  " + gene.getGeneName());
            }
        }
    }

    public static void accessECsOnly(UniProtService uniProtService, Query query) throws ServiceException {
        UniProtRetrievalExamples.printExampleHeader("ec numbers");
        QueryResult<UniProtComponent<String>> ecComponents = uniProtService.getECNumbers(query);
        while (ecComponents.hasNext()) {
            UniProtComponent ecComponent = (UniProtComponent)ecComponents.next();
            if (ecComponent.getComponent().isEmpty()) continue;
            System.out.println("accession: " + ecComponent.getAccession().getValue());
            for (String ec : ecComponent.getComponent()) {
                System.out.println("  " + ec);
            }
        }
    }

    public static void accessProteinNamesOnly(UniProtService uniProtService, Query query) throws ServiceException {
        UniProtRetrievalExamples.printExampleHeader("protein names");
        QueryResult<UniProtComponent<String>> proteinComponents = uniProtService.getProteinNames(query);
        int count = 0;
        while (proteinComponents.hasNext()) {
            ++count;
            UniProtComponent proteinComponent = (UniProtComponent)proteinComponents.next();
            if (proteinComponent.getComponent().isEmpty()) continue;
            System.out.println("accession: " + proteinComponent.getAccession().getValue());
            for (String protein : proteinComponent.getComponent()) {
                System.out.println("  " + protein);
            }
        }
        System.out.println("number of hits = " + count);
    }

    public static void accessFeaturesOnly(UniProtService uniProtService, Query query) throws ServiceException {
        UniProtRetrievalExamples.printExampleHeader("features");
        QueryResult<UniProtComponent<Feature>> featureComponents = uniProtService.getFeatures(query);
        while (featureComponents.hasNext()) {
            UniProtComponent featureComponent = (UniProtComponent)featureComponents.next();
            if (featureComponent.getComponent().isEmpty()) continue;
            System.out.println("accession: " + featureComponent.getAccession().getValue());
            for (Feature feature : featureComponent.getComponent()) {
                StringBuilder featureSB = new StringBuilder();
                FeatureLocation featureLocation = feature.getFeatureLocation();
                featureSB.append(feature.getType().getName()).append(", ").append(featureLocation.getStartModifier().toString()).append(featureLocation.getStart()).append(", ").append(featureLocation.getEnd()).append((Object)featureLocation.getEndModifier());
                System.out.println("  " + featureSB.toString());
            }
        }
    }

    public static void accessCommentsOnly(UniProtService uniProtService, Query query) throws ServiceException {
        UniProtRetrievalExamples.printExampleHeader("comments");
        QueryResult<UniProtComponent<Comment>> commentComponents = uniProtService.getComments(query);
        int count = 0;
        while (commentComponents.hasNext()) {
            ++count;
            UniProtComponent commentComponent = (UniProtComponent)commentComponents.next();
            if (commentComponent.getComponent().isEmpty()) continue;
            System.out.println("accession: " + commentComponent.getAccession().getValue());
            for (Comment comment : commentComponent.getComponent()) {
                System.out.println("   CommentType = " + comment.getCommentType().toDisplayName() + ", CommentStatus = " + comment.getCommentStatus().getValue());
            }
        }
        System.out.println("number of hits = " + count);
    }

    public static void accessSingleFullUniProtEntry(UniProtService uniProtService, String accession) throws ServiceException {
        UniProtEntry entry = uniProtService.getEntry(accession);
        if (entry == null) {
            System.out.println("Entry " + accession + " could not be retrieved");
        } else {
            System.out.println("Retrieved UniProtEntry object");
            System.out.println(entry.getUniProtId().getValue());
        }
    }

    public static void accessMultiFullUniProtEntry(UniProtService uniProtService, Query query) throws ServiceException {
        QueryResult<UniProtEntry> entries = uniProtService.getEntries(query);
        UniProtRetrievalExamples.printExampleHeader("full entry");
        int count = 0;
        while (entries.hasNext()) {
            ++count;
            UniProtEntry entry = (UniProtEntry)entries.next();
            System.out.println(entry.getUniProtId().getValue());
        }
        System.out.println("retrieved entries = " + count);
    }

    public static void accessResults(UniProtService uniProtService, Query query) throws ServiceException {
        UniProtRetrievalExamples.printExampleHeader("accessResults (choose which fields you want to see)");
        QueryResult<UniProtData> results = uniProtService.getResults(query, UniProtData.ComponentType.COMMENTS, UniProtData.ComponentType.FEATURES, UniProtData.ComponentType.GENES);
        System.out.println("   number of hits = " + results.getNumberOfHits());
        while (results.hasNext()) {
            UniProtData data = (UniProtData)results.next();
            System.out.println("   Accession: " + data.getAccession().getValue());
            System.out.println("   UniProtId: " + data.getUniProtId().getValue());
            block11: for (UniProtData.ComponentType type : UniProtData.ComponentType.values()) {
                if (!data.hasComponent(type)) continue;
                switch (type) {
                    case COMMENTS: {
                        UniProtRetrievalExamples.printExampleHeader("   ", " comments");
                        List comments = (List)data.getComponent(UniProtData.ComponentType.COMMENTS);
                        for (Object comment : comments) {
                            System.out.println("   CommentType = " + comment.getCommentType().toDisplayName() + ", CommentStatus = " + comment.getCommentStatus().getValue());
                        }
                        continue block11;
                    }
                    case FEATURES: {
                        Object comment;
                        UniProtRetrievalExamples.printExampleHeader("   ", "features");
                        List features = (List)data.getComponent(type);
                        comment = features.iterator();
                        while (comment.hasNext()) {
                            Feature feature = (Feature)comment.next();
                            StringBuilder featureSB = new StringBuilder();
                            FeatureLocation featureLocation = feature.getFeatureLocation();
                            featureSB.append(feature.getType().getName()).append(", ").append(featureLocation.getStartModifier().toString()).append(featureLocation.getStart()).append(", ").append(featureLocation.getEnd()).append((Object)featureLocation.getEndModifier());
                            System.out.println("     " + featureSB.toString());
                        }
                        continue block11;
                    }
                    case GENES: {
                        UniProtRetrievalExamples.printExampleHeader("   ", "genes");
                        List genes = (List)data.getComponent(type);
                        for (Object gene : genes) {
                            System.out.println("     " + gene.getGeneName());
                        }
                        continue block11;
                    }
                    case XREFS: {
                        Object gene;
                        UniProtRetrievalExamples.printExampleHeader("   ", "xrefs");
                        List xrefs = (List)data.getComponent(type);
                        gene = xrefs.iterator();
                        while (gene.hasNext()) {
                            DatabaseCrossReference xref = (DatabaseCrossReference)gene.next();
                            System.out.println("     " + xref.toString());
                        }
                        continue block11;
                    }
                    case ECNUMBER: {
                        UniProtRetrievalExamples.printExampleHeader("   ", "ec numbers");
                        List ecs = (List)data.getComponent(type);
                        for (Object ec : ecs) {
                            System.out.println("     " + (String)ec);
                        }
                        continue block11;
                    }
                    case PROTEIN_NAMES: {
                        Object ec;
                        UniProtRetrievalExamples.printExampleHeader("   ", "protein name");
                        List proteins = (List)data.getComponent(type);
                        ec = proteins.iterator();
                        while (ec.hasNext()) {
                            String protein = (String)ec.next();
                            System.out.println("     " + (String)protein);
                        }
                        continue block11;
                    }
                    case KEYWORDS: {
                        UniProtRetrievalExamples.printExampleHeader("   ", "keywords");
                        List kws = (List)data.getComponent(type);
                        for (Keyword kw : kws) {
                            System.out.println("     " + kw.getValue());
                        }
                        continue block11;
                    }
                    case TAXONOMY: {
                        UniProtRetrievalExamples.printExampleHeader("   ", "taxonomy");
                        List taxs = (List)data.getComponent(type);
                        for (NcbiTaxon tax : taxs) {
                            System.out.println("     " + tax.getValue());
                        }
                        continue block11;
                    }
                }
            }
        }
    }

    public static void showResultHits(UniProtService uniProtService) throws ServiceException {
        UniProtRetrievalExamples.printExampleHeader("showResultHits");
        Query query1 = UniProtQueryBuilder.ec("3.1.3").and(UniProtQueryBuilder.swissprot());
        QueryResult<PrimaryUniProtAccession> accessionQueryResult1 = uniProtService.getAccessions(query1);
        System.out.println("   inside SwissProt, the query, " + query1.getQueryString() + " has " + accessionQueryResult1.getNumberOfHits() + " matches.");
        Query query2 = UniProtQueryBuilder.ec("3.1.3").and(UniProtQueryBuilder.trembl());
        QueryResult<PrimaryUniProtAccession> accessionQueryResult2 = uniProtService.getAccessions(query2);
        System.out.println("   inside TrEMBL, the query, " + query2.getQueryString() + " has " + accessionQueryResult2.getNumberOfHits() + " matches.");
    }

    public static void printExampleHeader(String headerTitle) {
        UniProtRetrievalExamples.printExampleHeader("", headerTitle);
    }

    public static void printExampleHeader(String prefix, String headerTitle) {
        System.out.printf("%s=========== %s ==========%n", prefix, headerTitle);
    }
}

