/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniParcHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.AbstractLazyHit;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcService;

class LazyUniParcHit
extends AbstractLazyHit<UniParcEntry>
implements UniParcHit {
    private final BlastSummary summary;
    private final AbstractLazyHit.ReadEntryService<UniParcEntry> readEntryService;

    public LazyUniParcHit(BlastSummary summary, UniParcService searchService) {
        if (summary == null) {
            throw new IllegalArgumentException("Summary is null");
        }
        if (searchService == null) {
            throw new IllegalArgumentException("Search service is null");
        }
        this.summary = summary;
        this.readEntryService = new UniParcReadEntryService(searchService);
    }

    @Override
    public UniParcEntry getEntry() {
        return this.getEntry(this.summary.getEntryId(), this.readEntryService);
    }

    @Override
    public BlastSummary getSummary() {
        return this.summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LazyUniParcHit)) {
            return false;
        }
        LazyUniParcHit that = (LazyUniParcHit)o;
        return this.summary.equals(that.summary);
    }

    public int hashCode() {
        return this.summary.hashCode();
    }

    public String toString() {
        return "UniProtHitImpl{summary=" + this.summary + '}';
    }

    private class UniParcReadEntryService
    implements AbstractLazyHit.ReadEntryService<UniParcEntry> {
        private UniParcService searchService;

        public UniParcReadEntryService(UniParcService searchService) {
            this.searchService = searchService;
        }

        @Override
        public UniParcEntry getEntry(String entryId) throws ServiceException {
            return this.searchService.getEntry(entryId);
        }
    }
}

