/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.sequence;

import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Flag;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FlagType;
import uk.ac.ebi.kraken.model.uniprot.description.FlagImpl;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.SequenceType;
import uk.ac.ebi.kraken.xml.uniprot.GenericUpdater;

public class ProteinDescriptionUpdater
implements GenericUpdater<ProteinDescription, SequenceType> {
    @Override
    public void fromXmlBinding(ProteinDescription modelObject, SequenceType xmlObject) {
        FlagImpl flag;
        if (xmlObject.isPrecursor() != null && xmlObject.isPrecursor().booleanValue()) {
            flag = new FlagImpl();
            modelObject.getFlags().add(flag);
            flag.setFlagType(FlagType.PRECURSOR);
        }
        if (xmlObject.getFragment() != null && xmlObject.getFragment().equals("single")) {
            flag = new FlagImpl();
            modelObject.getFlags().add(flag);
            flag.setFlagType(FlagType.FRAGMENT);
        }
        if (xmlObject.getFragment() != null && xmlObject.getFragment().equals("multiple")) {
            flag = new FlagImpl();
            modelObject.getFlags().add(flag);
            flag.setFlagType(FlagType.FRAGMENTS);
        }
    }

    @Override
    public void toXmlBinding(SequenceType xmlObject, ProteinDescription modelObject) {
        for (Flag type : modelObject.getFlags()) {
            switch (type.getFlagType()) {
                case FRAGMENT: {
                    xmlObject.setFragment("single");
                    break;
                }
                case FRAGMENTS: {
                    xmlObject.setFragment("multiple");
                    break;
                }
                case PRECURSOR: {
                    xmlObject.setPrecursor(true);
                }
            }
        }
    }
}

