/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.description;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ProteinType;
import uk.ac.ebi.kraken.xml.uniprot.description.ContainsSectionHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.EcNumberHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.FieldAlternativeNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.GenericSectionHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.IncludesSectionHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.MainSectionHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.RecommendedNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.description.SubmittedNameHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class DescriptionHandler
implements GenericHandler<ProteinDescription, ProteinType> {
    private final UniProtFactory uniprotFactory;
    private final GenericSectionHandler<ProteinType> mainSectionHandler;
    private final GenericSectionHandler<ProteinType.Domain> includesSectionHandler;
    private final GenericSectionHandler<ProteinType.Component> containsSectionHandler;

    public DescriptionHandler(UniProtFactory factory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler, EcNumberHandler ecNumberHandler) {
        this.uniprotFactory = factory;
        EnumMap<NameType, GenericNameHandler> nameHandlerMap = new EnumMap<NameType, GenericNameHandler>(NameType.class);
        nameHandlerMap.put(NameType.RECNAME, new RecommendedNameHandler(objectFactory, factory, evidenceReferenceHandler, ecNumberHandler));
        nameHandlerMap.put(NameType.ALTNAME, new FieldAlternativeNameHandler(objectFactory, factory, evidenceReferenceHandler, ecNumberHandler));
        nameHandlerMap.put(NameType.SUBNAME, new SubmittedNameHandler(objectFactory, factory, evidenceReferenceHandler, ecNumberHandler));
        this.mainSectionHandler = new MainSectionHandler(objectFactory, factory, nameHandlerMap);
        this.includesSectionHandler = new IncludesSectionHandler(objectFactory, factory, nameHandlerMap);
        this.containsSectionHandler = new ContainsSectionHandler(objectFactory, factory, nameHandlerMap);
    }

    @Override
    public ProteinDescription fromXmlBinding(ProteinType proteinType) {
        ProteinDescription proteinDescription = this.uniprotFactory.buildProteinDescription();
        proteinDescription.setSection(this.mainSectionHandler.fromXmlSection(proteinType));
        this.populateIncludes(proteinType, proteinDescription);
        this.populateContains(proteinType, proteinDescription);
        return proteinDescription;
    }

    private void populateIncludes(ProteinType proteinType, ProteinDescription proteinDescription) {
        List<ProteinType.Domain> domainsList = proteinType.getDomain();
        ArrayList<Section> includesSectionList = new ArrayList<Section>();
        for (ProteinType.Domain domain : domainsList) {
            Section includesSection = this.includesSectionHandler.fromXmlSection(domain);
            if (includesSection == null) continue;
            includesSectionList.add(includesSection);
        }
        proteinDescription.setIncludes(includesSectionList);
    }

    private void populateContains(ProteinType proteinType, ProteinDescription proteinDescription) {
        List<ProteinType.Component> componentsList = proteinType.getComponent();
        ArrayList<Section> containsSectionList = new ArrayList<Section>();
        for (ProteinType.Component component : componentsList) {
            Section containsSection = this.containsSectionHandler.fromXmlSection(component);
            if (containsSection == null) continue;
            containsSectionList.add(containsSection);
        }
        proteinDescription.setContains(containsSectionList);
    }

    @Override
    public ProteinType toXmlBinding(ProteinDescription description) {
        ProteinType xmlProtein = this.populateMainSection(description);
        this.populateIncludesSection(description, xmlProtein);
        this.populateContainsSection(description, xmlProtein);
        return xmlProtein;
    }

    private ProteinType populateMainSection(ProteinDescription description) {
        Section mainSection = description.getSection();
        return this.mainSectionHandler.toXmlSection(mainSection);
    }

    private void populateIncludesSection(ProteinDescription description, ProteinType xmlProtein) {
        List<Section> includesSectionList = description.getIncludes();
        ArrayList<ProteinType.Domain> xmlIncludesSection = new ArrayList<ProteinType.Domain>();
        for (Section includesSection : includesSectionList) {
            ProteinType.Domain xmlIncludeSection = this.includesSectionHandler.toXmlSection(includesSection);
            if (xmlIncludeSection == null) continue;
            xmlIncludesSection.add(xmlIncludeSection);
        }
        if (!xmlIncludesSection.isEmpty()) {
            xmlProtein.getDomain().addAll(xmlIncludesSection);
        }
    }

    private void populateContainsSection(ProteinDescription description, ProteinType xmlProtein) {
        ArrayList<ProteinType.Component> xmlContainsSection = new ArrayList<ProteinType.Component>();
        List<Section> containsSectionList = description.getContains();
        for (Section containsSection : containsSectionList) {
            ProteinType.Component xmlContainSection = this.containsSectionHandler.toXmlSection(containsSection);
            if (xmlContainSection == null) continue;
            xmlContainsSection.add(xmlContainSection);
        }
        if (!xmlContainsSection.isEmpty()) {
            xmlProtein.getComponent().addAll(xmlContainsSection);
        }
    }
}

