/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReference;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReactionType;
import uk.ac.ebi.kraken.xml.uniprot.comment.ReactionReferenceHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class ReactionHandler
implements GenericHandler<Reaction, ReactionType> {
    private static final String EC = "EC";
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evRefHandler;
    private final ReactionReferenceHandler referenceHandler;

    public ReactionHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceRefHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evRefHandler = evidenceRefHandler;
        this.referenceHandler = new ReactionReferenceHandler(commentFactory, objectFactory);
    }

    @Override
    public Reaction fromXmlBinding(ReactionType xmlObject) {
        Reaction reaction = this.commentFactory.buildReaction();
        reaction.setName(xmlObject.getText());
        reaction.setReactionReferences(xmlObject.getDbReference().stream().filter(val -> !EC.equals(val.getType())).map(val -> this.referenceHandler.fromXmlBinding((DbReferenceType)val)).collect(Collectors.toList()));
        Optional<DbReferenceType> opEc = xmlObject.getDbReference().stream().filter(val -> EC.equals(val.getType())).findFirst();
        if (opEc.isPresent()) {
            reaction.setECNumber(opEc.get().getId());
        }
        if (!xmlObject.getEvidence().isEmpty()) {
            reaction.getEvidenceIds().addAll(this.evRefHandler.parseEvidenceIDs(xmlObject.getEvidence()));
        }
        return reaction;
    }

    @Override
    public ReactionType toXmlBinding(Reaction object) {
        List<Integer> evs;
        List<EvidenceId> evidenceIds;
        ReactionType reactionType = this.objectFactory.createReactionType();
        reactionType.setText(object.getName());
        reactionType.getDbReference().addAll(object.getReactionReferences().stream().map(val -> this.referenceHandler.toXmlBinding((ReactionReference)val)).collect(Collectors.toList()));
        if (!Strings.isNullOrEmpty((String)object.getECNumber())) {
            DbReferenceType dbReference = this.objectFactory.createDbReferenceType();
            dbReference.setType(EC);
            dbReference.setId(object.getECNumber());
            reactionType.getDbReference().add(dbReference);
        }
        if ((evidenceIds = object.getEvidenceIds()) != null && !evidenceIds.isEmpty() && !(evs = this.evRefHandler.writeEvidenceIDs(evidenceIds)).isEmpty()) {
            reactionType.getEvidence().addAll(evs);
        }
        return reactionType;
    }
}

