/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.math.BigInteger;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRange;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.LocationType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.PositionType;

public class MassSpectrometryRangeHandler
implements GenericHandler<MassSpectrometryRange, LocationType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;

    public MassSpectrometryRangeHandler(CommentFactory commentFactory, ObjectFactory objectFactory) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
    }

    @Override
    public MassSpectrometryRange fromXmlBinding(LocationType locationXML) {
        if (locationXML != null) {
            MassSpectrometryRange massSpectrometryRange = this.commentFactory.buildMassSpectrometryRange();
            PositionType beg = locationXML.getBegin();
            PositionType end = locationXML.getEnd();
            if (beg != null && beg.getPosition() != null) {
                massSpectrometryRange.setStart(beg.getPosition().intValue());
            }
            if (end != null && end.getPosition() != null) {
                massSpectrometryRange.setEnd(end.getPosition().intValue());
            }
            if (locationXML.getSequence() != null && !locationXML.getSequence().isEmpty()) {
                massSpectrometryRange.setIsoformId(this.commentFactory.buildMassSpectrometryIsoformId(locationXML.getSequence()));
            }
            return massSpectrometryRange;
        }
        return null;
    }

    @Override
    public LocationType toXmlBinding(MassSpectrometryRange massSpectrometryRange) {
        if (massSpectrometryRange != null) {
            LocationType locationXML = this.objectFactory.createLocationType();
            PositionType posStart = this.objectFactory.createPositionType();
            this.writePosition(posStart, massSpectrometryRange.getStart(), massSpectrometryRange.isStartUnknown());
            locationXML.setBegin(posStart);
            PositionType posEnd = this.objectFactory.createPositionType();
            this.writePosition(posEnd, massSpectrometryRange.getEnd(), massSpectrometryRange.isEndUnknown());
            locationXML.setEnd(posEnd);
            if (massSpectrometryRange.getIsoformId().getValue() != null && massSpectrometryRange.getIsoformId().getValue().trim().length() != 0) {
                locationXML.setSequence(massSpectrometryRange.getIsoformId().getValue());
            }
            return locationXML;
        }
        return null;
    }

    private void writePosition(PositionType pos, int value, boolean unknown) {
        if (unknown) {
            pos.setStatus("unknown");
        } else {
            BigInteger bigPos = BigInteger.valueOf(value);
            pos.setPosition(bigPos);
        }
    }
}

