/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import java.util.ArrayList;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.EvidencedValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsCommentComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsEvent;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EventType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.IsoformType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.EvidencedValueHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class AlternativeProductsHandler
implements GenericHandler<AlternativeProductsComment, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final GenericHandler<AlternativeProductsEvent, String> altProductsEventHandler;
    private final GenericHandler<AlternativeProductsIsoform, IsoformType> altProductsIsoformHandler;
    private final EvidencedValueHandler evidencedValueHandler;

    public AlternativeProductsHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        CommentItemFactory itemFactory = new CommentItemFactory();
        itemFactory.setCommentFactory(commentFactory);
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setEvidenceReferenceHandler(referenceHandler);
        this.altProductsEventHandler = itemFactory.buildAlternativeProductsEventHandler();
        this.altProductsIsoformHandler = itemFactory.buildAlternativeProductsIsoformHandler();
        this.evidencedValueHandler = new EvidencedValueHandler(objectFactory, referenceHandler);
    }

    @Override
    public AlternativeProductsComment fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML) {
        AlternativeProductsComment comment = (AlternativeProductsComment)this.commentFactory.buildComment(CommentType.ALTERNATIVE_PRODUCTS);
        if (commentXML.getEvent() != null && !commentXML.getEvent().isEmpty()) {
            for (EventType event : commentXML.getEvent()) {
                comment.getEvents().add(this.altProductsEventHandler.fromXmlBinding(event.getType()));
            }
        }
        if (commentXML.getIsoform() != null && !commentXML.getIsoform().isEmpty()) {
            for (IsoformType isoform : commentXML.getIsoform()) {
                comment.getIsoforms().add(this.altProductsIsoformHandler.fromXmlBinding(isoform));
            }
        }
        if (!commentXML.getText().isEmpty()) {
            AlternativeProductsCommentComment commentComment = this.commentFactory.buildAlternativeProductsCommentComment();
            ArrayList<EvidencedValue> evValues = new ArrayList<EvidencedValue>();
            for (EvidencedStringType evStr : commentXML.getText()) {
                evValues.add(this.evidencedValueHandler.fromXmlBinding(evStr));
            }
            commentComment.setTexts(evValues);
            comment.setComment(commentComment);
        }
        return comment;
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType toXmlBinding(AlternativeProductsComment comment) {
        uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML = this.objectFactory.createCommentType();
        if (comment != null) {
            AlternativeProductsCommentComment commentComment;
            if (comment.getEvents() != null) {
                for (AlternativeProductsEvent event : comment.getEvents()) {
                    EventType eventXML = this.objectFactory.createEventType();
                    eventXML.setType(this.altProductsEventHandler.toXmlBinding(event).toLowerCase());
                    commentXML.getEvent().add(eventXML);
                }
            }
            if (comment.getIsoforms() != null) {
                for (AlternativeProductsIsoform isoform : comment.getIsoforms()) {
                    commentXML.getIsoform().add(this.altProductsIsoformHandler.toXmlBinding(isoform));
                }
            }
            if ((commentComment = comment.getComment()) != null && !commentComment.getTexts().isEmpty()) {
                for (EvidencedValue evValue : commentComment.getTexts()) {
                    EvidencedStringType textAbsorption = this.evidencedValueHandler.toXmlBinding(evValue);
                    commentXML.getText().add(textAbsorption);
                }
            }
            commentXML.setType("alternative products");
            return commentXML;
        }
        return null;
    }
}

